HOMEPAGE = "www.multitech.net"
PRIORITY = "optional"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"

RDEPENDS_${PN} += "bash"
RDEPENDS_${PN}-eocg += "bash"

SRC_URI = "file://mlinux-wifi-ap \
	file://mlinux-dhcpd \
	file://mlinux-set-apn \
	file://mlinux-switch-apn \
	file://mlinux-switch-cell-fw \
	file://mlinux-cell-router \
	file://mlinux-cell-radio-ready \
	file://mlinux-firmware-upgrade \
	file://radio-reset-h5 \
	file://chkmtd \
	file://rewritebstrap \
"

PACKAGES = "${PN}-eocg ${PN}"

FILES_${PN}-eocg = "${sbindir}/radio-reset-h5 ${libexecdir}/bootstrap"

do_install() {
	install -d ${D}${sbindir} ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-wifi-ap ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-dhcpd ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-set-apn ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-switch-apn ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-switch-cell-fw ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-cell-router ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-cell-radio-ready ${D}${sbindir}
	install -m 755 ${WORKDIR}/mlinux-firmware-upgrade ${D}${sbindir}
	install -m 755 ${WORKDIR}/radio-reset-h5 ${D}${sbindir}
	install -d -m 755 ${D}/${libexecdir}/bootstrap/
	install -m 755 ${WORKDIR}/chkmtd ${D}/${libexecdir}/bootstrap/
	install -m 755 ${WORKDIR}/rewritebstrap ${D}/${libexecdir}/bootstrap/
}



pkg_postinst_${PN}-eocg() {
	ln -sf ${libexecdir}/bootstrap/chkmtd $D/etc/cron.daily
    	if ! grep -q -s cron\.daily $D/var/spool/cron/root; then
        	echo "adding crontab"
        	test -d $D/var/spool/cron || mkdir -p $D/var/spool/cron
        	echo "25 6 * * *    cd / && run-parts /etc/cron.daily" >> $D/var/spool/cron/root
    	fi
}


pkg_prerm_${PN}-eocg() {
	rm $D/etc/cron.daily/chkmtd
}
