DESCRIPTION = "Provides default system config files and /var/config fs"
SECTION = "base"
LICENSE = "MIT"
RDEPENDS_${PN} += "bash"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"
PACKAGE_ARCH = "all"
PR = "r9"
PACKAGES =+ "${PN}-mths"
inherit update-rc.d

INITSCRIPT_NAME = "config"
INITSCRIPT_PARAMS = "start 31 S ."

FILESEXTRAPATHS_prepend := "${THISDIR}/config:"
FILESEXTRAPATHS_prepend_${PN} := "${THISDIR}/mths_config:"

SRC_URI = "\
  file://network \
  file://ppp \
  file://config.init \
  file://config-mths \
  file://chat_wrapper \
  file://chat_wrapper.default \
  file://99_radio \
"

RDEPENDS_${PN}-mths += "${PN}"

CONFFILES_${PN} += "${sysconfdir}/defaults.tar.gz"
CONFIGFILES = "network/interfaces ppp"

CONFIGFILES_MTHS = "config-mths"

fakeroot do_install () {
    cd ${WORKDIR}

    # default config files
    rm -f defaults.tar.gz
    chown root:root -R ${CONFIGFILES}
    tar czf defaults.tar.gz ${CONFIGFILES}
    install -d ${D}${sysconfdir}
    install -m 0644 ${WORKDIR}/defaults.tar.gz ${D}${sysconfdir}/defaults.tar.gz

    # save root password for resetting to defaults
    echo -n '${ROOT_PASSWORD_HASH}' > ${D}${sysconfdir}/default_pass
    chmod 400 ${D}${sysconfdir}/default_pass

    # init script
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/config.init ${D}${sysconfdir}/init.d/config

    # mths adjustments
    tar -C ${CONFIGFILES_MTHS} -czf defaults-mths.tar.gz .
    install -m 0644 ${WORKDIR}/defaults-mths.tar.gz ${D}${sysconfdir}/defaults-mths.tar.gz

    install -d ${D}${sysconfdir}/default
    install -d ${D}${sysconfdir}/default/volatiles
    install -d ${D}${libexecdir}/ppp
    install -m 0755 ${WORKDIR}/chat_wrapper ${D}${libexecdir}/ppp/
    install -m 0644 ${WORKDIR}/chat_wrapper.default ${D}${sysconfdir}/default/chat_wrapper
    install -m 0644 ${WORKDIR}/99_radio ${D}${sysconfdir}/default/volatiles
}

FILES_${PN} = "${sysconfdir}/defaults.tar.gz ${sysconfdir}/default_pass"
FILES_${PN} += "${sysconfdir}/init.d/config ${sysconfdir}/default ${libexecdir}/ppp/chat_wrapper"
FILES_${PN} += "${sysconfdir}/default/volatiles"

FILES_${PN}-mths = "${sysconfdir}/defaults-mths.tar.gz"

# Create the hotspot version of defaults.tar.gz
pkg_postinst_${PN}-mths() {
  X=$D/tmp/mths
  mkdir -p $X
  export X
  (
    
    set -x
    if tar -tf $D${sysconfdir}/defaults.tar.gz | grep dnsmasq ; then
        :
    else
        tb=$X/tarball # Tarball directory
        mkdir $tb
        tar -C $tb -xf $D/etc/defaults.tar.gz
        tar -C $tb -xf $D/etc/defaults-mths.tar.gz
        if ! grep '^auto wifi1' $tb/network/interfaces ; then
            cat $tb/network/interfaces $tb/network/interfaces.mths >$tb/network/interfaces.new
            mv $tb/network/interfaces $tb/network/interfaces.old
            mv $tb/network/interfaces.new $tb/network/interfaces
        fi
        tar -C $tb -cf $D/etc/defaults.tar.gz .
    fi
  ) >$X/postinsttrace.txt 2>&1
  # Comment out the final line for a trace.
  rm -rf $X
}
