DESCRIPTION = "Default reset button handler"
SECTION = "base"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"
PR = "r1"
RDEPENDS_${PN} += "bash"

inherit update-rc.d

INITSCRIPT_NAME = "reset-handler"
INITSCRIPT_PARAMS = "start 95 2 3 4 5 ."
CONFFILES_${PN} = "${sysconfdir}/default/reset-handler"

SRC_URI = "\
  file://reset-handler.sh \
  file://reset-handler.init \
  file://reset-handler.default \
"

do_install () {
    install -d ${D}${sbindir}
    install -m 0755 ${WORKDIR}/reset-handler.sh ${D}${sbindir}/reset-handler

    # init script
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/reset-handler.init ${D}${sysconfdir}/init.d/reset-handler
    
    install -d ${D}${sysconfdir}/default
    install -m 0644 ${WORKDIR}/reset-handler.default ${D}${sysconfdir}/default/reset-handler
}
