#!/bin/bash
# This function is deprecated.
# Use gpsd_settime instead.
# PPS= 1484247472.29561104 clock= 1484247990.00000000 offset= 517.704388959
# DEBUG=1 to set debug
NAME=gpsd_ubx_settime
shopt -s expand_aliases
alias LG="logger -t $NAME"
function kill_it
{
    cmd=$1
    pid=$2
    sig=$3
    ((DEBUG)) && LG -p user.info "terminating $cmd(${pid}) with SIG${sig}"
    kill -SIG${sig} ${pid}
    result=$?
    ((DEBUG)) && LG -p user.info "kill -SIG${sig} ${pid} result is $result"
}        

trap "stty echo icanon" exit

OIFS=$IFS
IFS=$'\n'
if ! /usr/sbin/gpsd_ubx_fixed </dev/null ; then
   LG -s -p user.warn "GPS does not have a fix yet.  Try again later."
   exit 1
fi


# Terminate gpsmon after 10 seconds if it is our child
# gpsmon has issues with terminals and stalling on terminal
# read of the console.
(
  sleep 10
  ppid=$BASHPID
  pgid=$(ps --no-heading -o pgid -p $ppid)
  
  if ((${#pgid} == 0)) ; then
    LG -p user.err "Could not find a pgid for $ppid"
    ps -fjp $ppid | LG -p user.error
  fi

  # pgrep does not work during boot.
  pgrpmemb=$(ps --no-heading -o pgid,pid,comm -e | grep '^ *'"${pgid}"' *' | sed -r 's/^ *[0-9]+ *//')
  gpsmonpid=$(echo "${pgrpmemb}" | egrep '[[:space:]]gpsmon$' | sed 's/[[:space:]].*//')

  ((DEBUG)) && LG -p user.info "$pgid is pgid $gpsmonpid is gpsmonpid"
  # Find the gpsmonpid that is our grandchild
  ((didkill=0))
  
  # for loop is in case gpsmonpid has children.
  for p in ${gpsmonpid} ; do
    if ((${#p})) ; then
        kill_it gpsmon $p TERM
        ((didkill=p))
        break
    fi
  done
  if ((didkill == 0)) ; then
    exit 0
  fi
  # Do a sigkill to be sure.
  sleep 2
  kill_it gpsmon $didkill KILL
) &
                    
epoch=$(gpsmon -a 2>&1 | ( while read ln ; do
	if [[ $ln =~ ^[[:space:]]*PPS=.*clock=[[:space:]]*([0-9]*)\. ]] ; then
		echo ${BASH_REMATCH[1]}
		break
	fi
done ))
if [[ $epoch =~ ^[0-9]+$ ]] ; then
  LG -p user.warn "Updating time to epoch time, ${epoch}."
  date +%s -s @${epoch} >/dev/null
else
  LG -p user.err "gpsmon output is bad."
  exit 1
fi
exit 0
