#!/bin/bash
# This program creates an installer bash script.
# To install you execute:
# bash gpsdipk.sh
# Files needed
# ~/lib/opkginstall.sh
# ~/lib/bashinstaller.sh
#
function usage
{
  echo 'bldgpsd [mlinuxdir]' 2>&1
  exit
}
function cleanup
{
  if [[ $tmpdir =~ ^/var/tmp/gpsdbld ]] ; then
    rm -rf $tmpdir
  fi
}
if (($# != 1)) ; then
  usage
fi
trap cleanup exit
mlpath="$1"


fullpath=$(readlink ${mlpath})
tmpdirtemplate=/var/tmp/gpsdbld.XXXXX
tmpdir=$(mktemp -d $tmpdirtemplate)
FLIST=\
"
libpanelw5_*_arm926ejste.ipk
python-curses_*_arm926ejste.ipk
python-json_*_arm926ejste.ipk
libgps22_0*_arm926ejste.ipk  
gpsd_*_arm926ejste.ipk 
gpsd-conf_*_arm926ejste.ipk 
gpsd-gpsctl_*_arm926ejste.ipk 
gpsd-udev_*_arm926ejste.ipk 
gps-utils_*_arm926ejste.ipk 
python-pygps_*_arm926ejste.ipk 
ntp_*_arm926ejste.ipk 
ntp-utils_*_arm926ejste.ipk 
ntp-tickadj_*_arm926ejste.ipk 
busybox_*_arm926ejste.ipk 
"
armpath=${mlpath}/build/tmp/deploy/ipk/arm926ejste
if ! [[ -d $armpath ]] ; then
  echo $armpath does not exist.  No files to save
  exit 1
fi
mkdir ${tmpdir}/packages
cp ~/lib/bashinstaller.sh $tmpdir/packages/gpsdipk.sh

echo directory is $armpath
echo list is $FLIST
chmod +x ~/lib/bashinstaller.sh
(cd $armpath; cp ~/lib/opkginstall.sh . ; echo opkginstall.sh $FLIST | tr ' ' '\n' | cpio -ov -Hcrc >>${tmpdir}/packages/gpsdipk.sh ; rm opkginstall.sh)
mv ${tmpdir}/packages/gpsdipk.sh /var/tmp
echo installer is /var/tmp/gpsdipk.sh

