SUMMARY = "A TCP/IP Daemon simplifying the communication with GPS devices"
SECTION = "console/network"
LICENSE = "BSD"
LIC_FILES_CHKSUM = "file://COPYING;md5=d217a23f408e91c94359447735bc1800"
DEPENDS = "dbus dbus-glib ncurses python libusb1 chrpath-replacement-native pps-tools"
PROVIDES = "${PN} ${PN}-dbg ${PN}-dev"
PR="m5"
#BPN="gpsd"
#BP="${BPN}-${PV}"

EXTRANATIVEPATH += "chrpath-native"
FILESEXTRAPATHS_prepend = "${THISDIR}/gpsd-${PV}:"
# sysclockcrash is fixed for gpsd
# suppress text in binary is fixed for gpsctl

S = "${WORKDIR}/gpsd-${PV}"

SRC_URI = "${SAVANNAH_GNU_MIRROR}/gpsd/gpsd-${PV}.tar.gz \
    file://0001-SConstruct-prefix-includepy-with-sysroot-and-drop-sy.patch \
    file://0004-SConstruct-disable-html-and-man-docs-building-becaus.patch \
    file://0001-include-sys-ttydefaults.h.patch \
    file://0006-ubxtimelps.patch \
    file://0006-itu_r_tf_460_6.patch \
"
SRC_URI[md5sum] = "3b11f26b295010666b1767b308f90bc5"
SRC_URI[sha256sum] = "5cb1e6d880ec9a52c62492dd0e3d77451b7c7ad625895bd652f6354215aec23e"

inherit scons python-dir pythonnative systemd

SYSTEMD_OESCONS = "${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'true', 'false',d)}"

export STAGING_INCDIR
export STAGING_LIBDIR

# Necessary for python
export BUILD_SYS
export HOST_SYS

PACKAGECONFIG ??= "${@bb.utils.contains('DISTRO_FEATURES', 'bluetooth', 'bluez', '', d)}"
PACKAGECONFIG[bluez] = "bluez='false',${BLUEZ}"
PACKAGECONFIG[qt] = "qt='yes',qt='no',qt4-x11-free"
EXTRA_OESCONS = " \
    sysroot=${STAGING_DIR_TARGET} \
    libQgpsmm='false' \
    debug='true' \
    strip='false' \
    chrpath='yes' \
    systemd='${SYSTEMD_OESCONS}' \
    ashtech='no' \
    earthmate='no' \
    evermore='no' \
    fury='no' \
    fv18='no' \
    garmin='no' \
    garmintxt='no' \
    geostar='no' \
    greis='no' \
    itrax='no' \
    mtk3301='no' \
    navcom='no' \
    nmea0183='yes' \
    nmea2000='no' \
    oncore='no' \
    sirf='no' \
    skytraq='no' \
    superstar2='no' \
    tnt='no' \
    tripmate='no' \
    tsip='no' \
    ublox='yes' \
    ubloxtimels='yes' \
    aivdm='no' \
    gpsclock='no' \
    oceanserver='no' \
    libdir='${libdir}' \
    fixed_stop_bits='1' \
    pps='yes' \
    gpsd_group='gps' \
    ntpshm='yes' \
    prefix='usr' \
    ${PACKAGECONFIG_CONFARGS} \
"
# this cannot be used, because then chrpath is not found and only static lib is built
# target=${HOST_SYS}

do_compile_prepend() {
    export PKG_CONFIG_PATH="${PKG_CONFIG_PATH}"
    export PKG_CONFIG="PKG_CONFIG_SYSROOT_DIR=\"${PKG_CONFIG_SYSROOT_DIR}\" pkg-config"
    export STAGING_PREFIX="${STAGING_DIR_HOST}/${prefix}"
    export LINKFLAGS="${LDFLAGS}"
}
do_install() {
    export PKG_CONFIG_PATH="${PKG_CONFIG_PATH}"
    export PKG_CONFIG="PKG_CONFIG_SYSROOT_DIR=\"${PKG_CONFIG_SYSROOT_DIR}\" pkg-config"
    export STAGING_PREFIX="${STAGING_DIR_HOST}/${prefix}"
    export LINKFLAGS="${LDFLAGS}"

    export DESTDIR="${D}"
    install -d 755 ${D}${libdir}
    install libgps.so.24.* ${D}${libdir}
    cp -a libgps.so.24 ${D}${libdir}
    (cd ${D}${libdir};ln -sf libgps.so.24.* libgps.so)

    # support for dev (development)
    mkdir -p -m 0644 ${D}/${includedir}/gps
    install -m 0644 ${S}/gpsd.h ${D}/${includedir}/gps
    install -m 0644 ${S}/os_compat.h ${D}/${includedir}/gps
    install -m 0644 ${S}/revision.h ${D}/${includedir}/gps
    install -m 0644 ${S}/gpsdclient.h ${D}/${includedir}/gps
    install -m 0644 ${S}/gpsd_config.h ${D}/${includedir}/gps
    install -m 0644 ${S}/compiler.h ${D}/${includedir}/gps
    install -m 0644 ${S}/ppsthread.h ${D}/${includedir}/gps
    install -m 0644 ${S}/gps.h ${D}/${includedir}
    install -m 0644 ${S}/libgpsmm.h ${D}/${includedir}
}


FILES_${PN}-dev_append = " ${includedir}/gps.h ${includedir}/libgpsmm.h ${includedir}/gps ${libdir}/libgps.so"
FILES_${PN}-dev_remove = "${includedir} ${FILES_SOLIBSDEV} \
    ${libdir}/*.la ${libdir}/*.o ${libdir}/pkgconfig \
    ${datadir}/pkgconfig ${datadir}/aclocal \
    ${base_libdir}/*.o ${libdir}/${BPN}/*.la ${base_libdir}/*.la"

SUMMARY_${PN}-dbg = "Debug the C service library used for communicating with gpsd"
PACKAGES = "${PN} ${PN}-dbg ${PN}-dev"

FILES_${PN}-dbg_replace = "${prefix}/src/* ${libdir}/.debug/*"

SUMMARY_${PN} = "C service library used for communicating with gpsd"

RDEPENDS_${PN} += "dbus-lib"

FILES_${PN}_append = " ${libdir}/libgps.so.* "
FILES_${PN}_remove = "${bindir}/* ${sbindir}/*  ${libexecdir}/* \
    ${libdir}/lib*${SOLIBS} ${sysconfdir} ${sharedstatedir} \
    ${localstatedir} ${base_bindir}/* ${base_sbindir}/*  \
    ${base_libdir}/*${SOLIBS} ${base_prefix}/lib/udev \
    ${prefix}/lib/udev ${base_libdir}/udev ${libdir}/udev \
    ${datadir}/${BPN} ${libdir}/${BPN}/* ${datadir}/pixmaps \
    ${datadir}/applications ${datadir}/idl ${datadir}/omf \
    ${datadir}/sounds ${libdir}/bonobo/servers \
"
