DESCRIPTION = "A Ruby library that provides a class for using RS-232 serial ports"
HOMEPAGE = "https://github.com/hparra/ruby-serialport"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://LICENSE;md5=751419260aa954499f7abaabaa882bbe"
SECTION = "console/utils"
PRIORITY = "optional"

DEPENDS = "ruby"

PR = "r2"

# tag v1.3.0
SRCREV = "2781dbb1ffbf33d7c65478aa25dad5f954d0d3bf"

SRC_URI = "git://github.com/hparra/ruby-serialport.git;protocol=git"

S = "${WORKDIR}/git"
B = "${S}"

do_compile() {
  rp=$(ls -d ${STAGING_INCDIR}/ruby-* | head -1)
  ${CC} -v ${CFLAGS} ${LDFLAGS} -Iext/native -I${rp} -I${rp}/arm-linux-gnueabi -c ext/native/*.c
  ${CC} -v ${CFLAGS} ${LDFLAGS} --shared -o ext/native/serialport.so serialport.o posix_serialport_impl.o
}

do_install() {
  install -d ${D}${libdir}/ruby/serialport
  install lib/serialport.rb ${D}${libdir}/ruby/serialport.rb
  install ext/native/serialport.so -t ${D}${libdir}/ruby
}

FILES_${PN} = "${libdir}/ruby/serialport*"
FILES_${PN}-dbg += "${libdir}/ruby/.debug"
