DESCRIPTION = "Ruby bindings for the SQLite3 embedded database"
HOMEPAGE = "https://github.com/sparklemotion/sqlite3-ruby"
LICENSE = "BSD-3-Clause"
LIC_FILES_CHKSUM = "file://LICENSE;md5=f24ce0d57c8f8576a36e2803d35bcfec"
SECTION = "console/utils"
PRIORITY = "optional"

DEPENDS = "ruby sqlite3"

SRC_URI = "git://github.com/sparklemotion/sqlite3-ruby.git;branch=1-3-stable;tag=v${PV}"
S = "${WORKDIR}/git"

# Position independent code for shared lib
CFLAGS += "-fPIC"

do_compile() {
  ${CC} ${CFLAGS} ${LDFLAGS} -Iext/sqlite3 -Iext/native -I${STAGING_INCDIR}/ruby-2.2.0 -I${STAGING_INCDIR}/ruby-2.2.0/arm-linux-gnueabi -c ext/sqlite3/*.c -DHAVE_RB_INTEGER_PACK
  ${CC} ${CFLAGS} ${LDFLAGS} --shared -o ext/sqlite3/sqlite3_native.so *.o -lsqlite3
}

do_install() {
  install -d ${D}${libdir}/ruby ${D}${libdir}/ruby/sqlite3
  install lib/sqlite3.rb ${D}${libdir}/ruby/sqlite3.rb
  install lib/sqlite3/* ext/sqlite3/sqlite3_native.so -t ${D}${libdir}/ruby/sqlite3
}

FILES_${PN} = "${libdir}/ruby/sqlite3*"
FILES_${PN}-dbg += "${libdir}/ruby/sqlite3/.debug*"
