SUMMARY = "Library for password quality checking and generating random passwords"
HOMEPAGE = "https://launchpad.net/libpwquality"
LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://COPYING;md5=6bd2f1386df813a459a0c34fde676fc2"

SRC_URI = "https://launchpad.net/${BPN}/trunk/${PV}/+download/${BPN}-${PV}.tar.bz2 \
	   file://pwquality_conf.patch \
	   file://pam.configure \
	  "
SRC_URI[md5sum] = "2a3d4ba1d11b52b4f6a7f39622ebf736"
SRC_URI[sha256sum] = "74d2ea90e103323c1f2d6a6cc9617cdae6877573eddb31aaf31a40f354cc2d2a"

inherit autotools-brokensep pkgconfig gettext pythonnative

DEPENDS = "zlib cracklib libpam python"
RDEPENDS_${PN} = "libpam-runtime"

EXTRA_OECONF = " \
    --with-python-binary=${PYTHON} \
    --libdir=${base_libdir} \
"

do_compile() {
    # make distustils part for python bindings happy
    export STAGING_INCDIR=${STAGING_INCDIR}
    export STAGING_LIBDIR=${STAGING_LIBDIR}
    export BUILD_SYS=${BUILD_SYS}
    export HOST_SYS=${HOST_SYS}
    base_do_compile
}

do_install() {
    # make distustils part for python bindings happy
    export STAGING_INCDIR=${STAGING_INCDIR}
    export STAGING_LIBDIR=${STAGING_LIBDIR}
    export BUILD_SYS=${BUILD_SYS}
    export HOST_SYS=${HOST_SYS}
    autotools_do_install
    install -d -m755 ${D}/${datadir_native}/${PN}
    install ${WORKDIR}/pam.configure ${D}/${datadir_native}/${PN}
}

FILES_${PN} += " \
    ${base_libdir}/security/*.so \
    ${datadir_native}/ \
"
CONFFILES_${PN} += "${sysconfdir}"

PACKAGE_BEFORE_PN += "${PN}-python"

FILES_${PN}-python = " \
    ${PYTHON_SITEPACKAGES_DIR} \
"

FILES_${PN}-staticdev += " \
    ${PYTHON_SITEPACKAGES_DIR}/*.a \
    ${base_libdir}/security/*.a \
"
FILES_${PN}-dev += " \
    ${PYTHON_SITEPACKAGES_DIR}/*.la \
    ${base_libdir}/security/*.la \
    ${base_libdir}/pkgconfig/pwquality.pc \
"

FILES_${PN}-dbg += "\
    ${PYTHON_SITEPACKAGES_DIR}/.debug \
    ${base_libdir}/security/.debug \
"

# The postinstall installs libpwquality into PAM.
# The prerm removes libpwquatlity from PAM.
# The file we change is /etc/pam.d/common-password,
# which is a configuration file for libpam-runtime.
# We ignore failures in the post-install and pre-remove.
# so if the patch does not apply, pam will not use us.
pkg_postinst_${PN}() {
    PAM_CONFIGURE="/${datadir_native}/${PN}/pam.configure"
    if [[ -n $D ]] ; then
        LOG='printf %s\n'
        PAM_CONFIGURE="$D${PAM_CONFIGURE}"
        cd $D
    else
        LOG="logger -s -p user.info -t opkg\ libpwquality"
        cd /
    fi
    logsave=$(patch -p1 -N < "$PAM_CONFIGURE" 2>&1 || true)
    if [[ -n ${logsave} ]] ; then
        ${LOG} "In directory $(pwd)"
        ${LOG} "patch -p1 -N < $PAM_CONFIGURE"
        ${LOG} "${PN} patch: ${logsave}"
        
    fi
}

pkg_prerm_${PN}() {
    PAM_CONFIGURE="/${datadir_native}/${PN}/pam.configure"
    if [[ -n $D ]] ; then
        LOG='printf %s\n'
        PAM_CONFIGURE="$D${PAM_CONFIGURE}"
        cd $D
    else
        LOG="logger -s -p user.info -t opkg\ libpwquality"
        cd /
    fi
    logsave=$(patch -p1 -R < "$PAM_CONFIGURE" 2>&1 || true)
    if [[ -n ${logsave} ]] ; then
        ${LOG} "In directory $(pwd)"
        ${LOG} "patch -p1 -R < "$PAM_CONFIGURE""
        ${LOG} "${PN} remove patch: ${logsave}"
    fi
}
