SUMMARY = "Library for hooking into pam authentication"
HOMEPAGE = "https://github.com/jeroennijhof/pam_script"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=75859989545e37968a99b631ef42722e"

inherit autotools-brokensep pkgconfig
RDEPENDS_${PN} = "libpam-runtime perl"

SRC_URI = "git://github.com/jeroennijhof/pam_script.git;protocol=git"
SRCREV = "${PV}"	  
S = "${WORKDIR}/git"
PR="r2"

EXTRA_OECONF = " \
    --sysconfdir=${sysconfdir}/pam-script \
    --libdir=${base_libdir}/security \
"



FILES_${PN} += "${base_libdir}"
FILES_${PN}-doc += "${datadir_native}/man"

do_install_append() {
    oe_runmake DESTDIR=${D} install-data-hook install-exec-hook install-examples install-logger install-tally
    install -m 0644 ${S}/etc/README.pam_script ${D}/${sysconfdir}/pam-script
}
