#!/bin/bash
HOMEDIR=$(pwd)
# kernel modules and kernel related files.
PACKAGELIST='kernel-3* kernel-modules*  mts-io* kernel-module-*'
if (($(id -u) != 0)) ; then
    echo 'This script must be run as root.'
    exit 1
fi
set -e
if ! [[ -d image ]] || ! [[ -d packages ]] ; then
    echo must be in the directory with the image and packages directory
fi
sed -i -e "s?TARDIR?${HOMEDIR}?" packages/opkg/opkg.conf
cd image
md5sum -c uImage.md5
echo "Erasing the kernel partition"
kernel_mtd="/dev/$(cat /proc/mtd | grep '\"uImage\"' | cut -d : -f 1)"
flash_erase ${kernel_mtd} 0 0
echo "Writing the kernel partition"
nandwrite -p ${kernel_mtd} "uImage--"*
cd ../packages/mtcdt

temp=$(mktemp -p /tmp opkglog.XXXXXX)
echo "Saving install results to $temp"
opkg -f ${HOMEDIR}/packages/opkg/opkg.conf update 2>&1 >${temp}
set +e
((count=0)) || true
((err=0)) || true

max=$(ls ${PACKAGELIST} | wc -l)
pkgname=$(opkg list-installed 2>&1  | grep '^kernel-3' | sed -r 's/[[:space:]].*//')
# Probably due to a bug in opkg, whiteheat and vizzini conflict.
for f in ${pkgname} kernel-module-vizzini kernel-module-whiteheat ; do
    if ! opkg -f ${HOMEDIR}/packages/opkg/opkg.conf --force-depends remove $pkgname 2>&1 >>${temp} ; then
        echo "ERROR: Failed to remove package $pkgname" >>${temp}
        err++
    fi
done

for f in ${PACKAGELIST} ; do
    if ! opkg -f ${HOMEDIR}/packages/opkg/opkg.conf --force-downgrade --force-reinstall install $f 2>&1 >>${temp} ; then
        echo "Remove package $f because upgrade failed" >>${temp}
        pkgname=$(echo $f | sed -e 's/_.*//')
        opkg -f ${HOMEDIR}/packages/opkg/opkg.conf --force-depends remove $pkgname 2>&1 >>${temp}
        if ! opkg -f ${HOMEDIR}/packages/opkg/opkg.conf install $pkgname 2>&1 >>${temp} ; then
            echo "ERROR: Install of $f failed" >>${temp}
            ((err++))
        else
            ((count++))
        fi
    else
        ((count++))
    fi
   printf "\r%3d of %3d" $count $max
done

opkg -f ${HOMEDIR}/packages/opkg/opkg.conf --force-depends remove $pkgname 2>&1 >>${temp}
echo
if ((err > 0)) ; then
	echo "Installation failures.  See ${temp}"
	grep '^ERROR' ${temp}
fi
depmod -a
echo "Installed ${count} packages."
echo "Ready for reboot"
