SUMMARY = "Initial bootstrap for AT91 ARM MPUs"
DESCRIPTION = " \
		at91bootstrap is the second-level bootloader for Atmel AT91  \
		SoCs. It provides a set of algorithms to manage the hardware \
		initialization and to download the main application (or a    \
		third-level bootloader) from specified boot media to         \
		main memory and start it.                                    \
	      "
AUTHOR = "Atmel Corporation"
HOMEPAGE = "http://www.at91.com/linux4sam/bin/view/Linux4SAM/AT91Bootstrap"
BUGTRACKER = "https://github.com/linux4sam/at91bootstrap/issues"
SECTION = "bootloaders"
LICENSE = "ATMEL"
LIC_FILES_CHKSUM = "file://main.c;endline=27;md5=42f86d2f6fd17d1221c5c651b487a07f"


inherit cml1 deploy

SRC_URI_append = " \
	file://defconfig \
	file://onetime-slow-clock-switch.patch \
	file://disable-rtc-interrupts.patch \
	file://at91sam9x5_4bit_pmecc_header.bin \
"
SRC_URI_append_mtrv1 = " file://mtrv1-DDRlowDriveStrength.patch \
	file://defconfig.mtr \
	file://at91bootstrap-3.8-mtr.patch \
"
SRC_URI_append_mtr = " file://defconfig.mtr \
	file://at91bootstrap-3.8-mtr.patch \
"

SRC_URI_append_mt100eocg = " file://defconfig.mt100eocg \
	file://at91bootstrap-3.8-memory_bus_1.8v.patch \
"

# Software ECC version for beta release
SRC_URI_append_betamt100eocg = " file://defconfig.betamt100eocg \
	file://at91bootstrap-3.8-memory_bus_1.8v.patch \
"

# Software ECC version of bootstrap for writing with SAM-BA which
# uses Hamming code (Software) ECC.  This should be able to load
# U-Boot, which should then use On-Die ECC to write the entire
# NAND flash.
SRC_URI_append_sweccmt100eocg = " file://defconfig.sweccmt100eocg \
	file://at91bootstrap-3.8-memory_bus_1.8v.patch \
"

SRC_URI_append_mtcdt = " file://at91bootstrap-3.8-mtcdt.patch "
SRC_URI_append_mtcap = " file://at91bootstrap-3.8-mtcdt.patch "

AT91BOOTSTRAP_MACHINE ??= "${MACHINE}"

AT91BOOTSTRAP_CONFIG ??= "${AT91BOOTSTRAP_MACHINE}nf_uboot"
AT91BOOTSTRAP_CONFIG_at91sam9x5ek-sd ??= "${AT91BOOTSTRAP_MACHINE}sd_uboot"
AT91BOOTSTRAP_CONFIG_sama5d3-xplained-sd ??= "${AT91BOOTSTRAP_MACHINE}sd_uboot"
AT91BOOTSTRAP_CONFIG_sama5d4ek ??= "${AT91BOOTSTRAP_MACHINE}nf_uboot_secure"
AT91BOOTSTRAP_CONFIG_sama5d4-xplained ??= "${AT91BOOTSTRAP_MACHINE}nf_uboot_secure"
AT91BOOTSTRAP_CONFIG_sama5d4-xplained-sd ??= "${AT91BOOTSTRAP_MACHINE}sd_uboot_secure"
AT91BOOTSTRAP_CONFIG_sama5d2-xplained ??= "${AT91BOOTSTRAP_MACHINE}-bsrdf_uboot"
AT91BOOTSTRAP_CONFIG_sama5d2-xplained-sd ??= "${AT91BOOTSTRAP_MACHINE}-bsrsd_uboot"
AT91BOOTSTRAP_CONFIG_sama5d27-som1-ek ??= "${AT91BOOTSTRAP_MACHINE}qspi_uboot"
AT91BOOTSTRAP_CONFIG_sama5d27-som1-ek-sd ??= "${AT91BOOTSTRAP_MACHINE}sd_uboot"

AT91BOOTSTRAP_TARGET ??= "${AT91BOOTSTRAP_CONFIG}_defconfig"
AT91BOOTSTRAP_LOAD ??= "nandflashboot-uboot"
AT91BOOTSTRAP_LOAD_at91sam9x5ek-sd ??= "sdboot-uboot"
AT91BOOTSTRAP_LOAD_sama5d2-xplained ??= "dataflashboot-uboot"
AT91BOOTSTRAP_LOAD_sama5d2-xplained-sd ??= "sdboot-uboot"
AT91BOOTSTRAP_LOAD_sama5d27-som1-ek ??= "qspiboot-uboot"
AT91BOOTSTRAP_LOAD_sama5d27-som1-ek-sd ??= "sdboot-uboot"
AT91BOOTSTRAP_LOAD_sama5d3-xplained-sd ??= "sdboot-uboot"
AT91BOOTSTRAP_LOAD_sama5d4-xplained-sd ??= "sdboot-uboot"

AT91BOOTSTRAP_SUFFIX ?= "bin"
AT91BOOTSTRAP_IMAGE ?= "${AT91BOOTSTRAP_MACHINE}-${AT91BOOTSTRAP_LOAD}-${PV}.${PR}.${AT91BOOTSTRAP_SUFFIX}"
AT91BOOTSTRAP_BINARY ?= "at91bootstrap.${AT91BOOTSTRAP_SUFFIX}"
AT91BOOTSTRAP_SYMLINK ?= "at91bootstrap-${AT91BOOTSTRAP_MACHINE}.${AT91BOOTSTRAP_SUFFIX}"

EXTRA_OEMAKE = 'CROSS_COMPILE=${TARGET_PREFIX} REVISION=${PR} CC="${TARGET_PREFIX}gcc ${TOOLCHAIN_OPTIONS}"'

do_configure() {
	# Copy board defconfig to .config if .config does not exist. This
	# allows recipes to manage the .config themselves in
	# do_configure_prepend().
	if [ -f "${S}/board/${AT91BOOTSTRAP_MACHINE}/${AT91BOOTSTRAP_TARGET}" ] && [ ! -f "${B}/.config" ]; then
		cp "${S}/board/${AT91BOOTSTRAP_MACHINE}/${AT91BOOTSTRAP_TARGET}" "${B}/.config"
	fi

	# Copy defconfig to .config if .config does not exist. This allows
	# recipes to manage the .config themselves in do_configure_prepend()
	# and to override default settings with a custom file.
	if [[ ${MACHINE} == mtr ]] || [[ ${MACHINE} == mtrv1 ]] ; then
            CTYPE=".mtr"
      fi

	case "${MACHINE}" in
		mt100eocg)
		CTYPE=".mt100eocg"
		;;
		sweccmt100eocg)
		CTYPE=".sweccmt100eocg"
		;;
		betamt100eocg)
		CTYPE=".betamt100eocg"
		;;
	esac
	
	if [ -f "${WORKDIR}/defconfig${CTYPE}" ] && [ ! -f "${B}/.config" ]; then
		cp "${WORKDIR}/defconfig${CTYPE}" "${B}/.config"
	fi

	if [ ! -f "${S}/.config" ]; then
		bbfatal "No config files found"
	fi

	cml1_do_configure
}

do_compile() {
	if [ "${@bb.utils.contains('DISTRO_FEATURES', 'ld-is-gold', 'ld-is-gold', '', d)}" = "ld-is-gold" ] ; then
		sed -i 's/$(CROSS_COMPILE)ld$/$(CROSS_COMPILE)ld.bfd/g' ${S}/Makefile
	fi

	unset CFLAGS CPPFLAGS LDFLAGS
	oe_runmake
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${S}/binaries/${AT91BOOTSTRAP_BINARY} ${DEPLOYDIR}/${AT91BOOTSTRAP_IMAGE}

	cd ${DEPLOYDIR}
	rm -f ${AT91BOOTSTRAP_BINARY} ${AT91BOOTSTRAP_SYMLINK}
	ln -sf ${AT91BOOTSTRAP_IMAGE} ${AT91BOOTSTRAP_SYMLINK}
	ln -sf ${AT91BOOTSTRAP_IMAGE} ${AT91BOOTSTRAP_BINARY}

	# Create a symlink ready for file copy on SD card
	rm -f boot.bin BOOT.BIN
	ln -sf ${AT91BOOTSTRAP_IMAGE} BOOT.BIN

	# Create padded version.  Padded version is to be eliminated later.
        cp -f ${WORKDIR}/at91sam9x5_4bit_pmecc_header.bin ${DEPLOYDIR}/at91bootstrap_pmecc_padded.bin
        cat ${DEPLOYDIR}/${AT91BOOTSTRAP_IMAGE} >> ${DEPLOYDIR}/at91bootstrap_pmecc_padded.bin
}

addtask deploy before do_build after do_compile

PACKAGE_ARCH = "${MACHINE_ARCH}"

