# Script to copy the EEPROM to /run/config and
# init script to populate /run/config
inherit update-rc.d
PR = "r1"
DESCRIPTION = "EEPROM copyting tool"
HOMEPAGE = "http://www.multitech.net/"
SECTION = "console/utils"
PRIORITY = "optional"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://${COREBASE}/meta/COPYING.GPLv2;md5=751419260aa954499f7abaabaa882bbe"
RDEPENDS_${PN} =+ "bash"

SRCREV = "${PV}"

SRC_URI = "file://${PN}.sh \
           file://init"

PARALLEL_MAKE = ""


fakeroot do_install_append() {
    # install MTCAP mts-io init script
    install -d 0755 ${D}${base_sbindir}
    install -d 0755 ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/${PN}.sh  ${D}${base_sbindir}/${PN}
    install -m 0755 ${WORKDIR}/init  ${D}${sysconfdir}/init.d/eeprom-config
}


INITSCRIPT_NAME = "eeprom-config"
# Must start after MTS-IO to read the accessory cards.
INITSCRIPT_PARAMS = "start 40 S ."
