DESCRIPTION = "Compile MT board device tree overlays"
LICENSE = "(GPLv2+)"
LIC_FILES_CHKSUM = "file://COPYING;md5=94d55d512a9ba36caa9b7df079bae19f"
PACKAGE_ARCH = "${MACHINE_ARCH}"

# By using an overlay, we should be able to support multiple pinouts
# using the same image.  The overlays go into /lib/dtoverlays.
# There names are: [hw-version]-driver.dtbo
#  e.g. /lib/dtoverlays/MTRV1-0.0-pps.dtbo
# The idea is that mts-io will search for the overlays, and install the
# appropriate device tree overlay for the current hw-version.

dt_dir = "/lib/dtoverlays"

PR = "r1"

SRC_URI = "git://git.multitech.net/mt-dt-overlay.git;protocol=git"

SRCREV = "${PV}"

DEPENDS = "virtual/kernel u-boot-mkimage-native"

S = "${WORKDIR}/git"

do_compile[depends] += "virtual/kernel:do_deploy virtual/kernel:do_shared_workdir"
do_compile[nostamp] = "1"

do_compile () {
        echo MACHINE is ${MACHINE}
	oe_runmake DTC=/usr/bin/dtc KERNEL_DIR=${STAGING_KERNEL_DIR} KERNEL_BUILD_DIR=${KERNEL_PATH} ${MACHINE}_dtbos
}

FILES_${PN} = "${dt_dir}"

addtask install after do_compile

do_install () {
    # Copy files to /lib/dt-overlay/main (mtac cards will be in mtac)
    if [ -e ${AT91BOOTSTRAP_MACHINE} ]; then
        install -d ${D}/${dt_dir}
        (
            cd ${MACHINE}
            for f in *.dtbo ; do
                if [[ -h $f ]] ; then
                    cp -df ${f} ${D}/${dt_dir}
                else
                    install ${f} ${D}/${dt_dir}
                fi
            done
        )
    fi;
}

