DESCRIPTION = "ID EEPROM tool for MTCDP"
HOMEPAGE = "http://www.multitech.net/"
SECTION = "console/utils"
PRIORITY = "optional"
LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://COPYING;md5=94d55d512a9ba36caa9b7df079bae19f"
INC_PR = "r2"
DEPENDS = "mts-io openssl"
RDEPENDS_${PN} =+ "bash"

SRCREV = "${PV}"

SRC_URI = "git://git.multitech.net/mts-id-eeprom.git;protocol=git"
SRC_URI_append_mtcdt = " file://mtcdt-fpga-v31.hex  file://mtcdt-fpga-v33.hex"
SRC_URI_append_mtcap = " file://mtcap-fpga-v31.hex  file://mtcap-fpga-v33.hex"

S = "${WORKDIR}/git"

inherit autotools

PARALLEL_MAKE = ""

FILES_${PN}_append_mtcap += "${sbindir}/mts-fpga-loader-1_5"
FILES_${PN}_append_mtcdt += "${sbindir}/mts-fpga-loader-1_5"
FILES_${PN}_append_mtcap += "${libdir}/mts-flash-binaries/mtcap-fpga-v31.hex ${libdir}/mts-flash-binaries/mtcap-fpga-v33.hex "
FILES_${PN}_append_mtcdt += "${libdir}/mts-flash-binaries/mtcdt-fpga-v31.hex ${libdir}/mts-flash-binaries/mtcdt-fpga-v33.hex "



fakeroot do_install_append_mtcap() {
    # install MTCAP mts-io init script
    install -d -m 0755 ${D}${libdir}/mts-flash-binaries
    install -m 0444 ${WORKDIR}/${MACHINE}-fpga-v31.hex  ${D}${libdir}/mts-flash-binaries
    install -m 0444 ${WORKDIR}/${MACHINE}-fpga-v33.hex  ${D}${libdir}/mts-flash-binaries
}

fakeroot do_install_append_mtcdt() {
    # install MTCAP mts-io init script
    install -d -m 0755 ${D}${libdir}/mts-flash-binaries
    install -m 0444 ${WORKDIR}/${MACHINE}-fpga-v31.hex  ${D}${libdir}/mts-flash-binaries
    install -m 0444 ${WORKDIR}/${MACHINE}-fpga-v33.hex  ${D}${libdir}/mts-flash-binaries
}

