DESCRIPTION = "mts-io controller and sysfs wrapper"
HOMEPAGE = "http://www.multitech.net/"
SECTION = "base"
PRIORITY = "optional"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://io-module/COPYING;md5=94d55d512a9ba36caa9b7df079bae19f \
                    file://io-tool/COPYING;md5=94d55d512a9ba36caa9b7df079bae19f \
"
DEPENDS = "virtual/kernel"
INC_PR = "r1"

//SRCREV = "${PV}"
SRCREV = "${AUTOREV}"

MTSIO_BRANCH="master"
MTSIO_BRANCH_mt100eocg="mt100eocg"
MTSIO_BRANCH_betamt100eocg="mt100eocg"
SRC_URI = " \
    git://git.multitech.net/mts-io.git;protocol=git \
    file://led-status_heartbeat_trigger \
    file://lora-led-updater \
    file://mts-io.init \
    file://mts-io.blacklist \
    file://mts-io.mtcap.init \
    file://mts-io.conf \
"
S = "${WORKDIR}/git"

inherit module
inherit update-rc.d
inherit autotools

# add this since we aren't using module.bbclass
addtask make_scripts after do_patch before do_compile
do_make_scripts[lockfiles] = "${TMPDIR}/kernel-scripts.lock"
do_make_scripts[deptask] = "do_populate_sysroot"

EXTRA_OEMAKE = " -C ${STAGING_KERNEL_DIR} \
                KBUILD_VERBOSE=1 \
                M=${S}/io-module \
                modules \
                "

do_compile () {
    bbnote make   "$@"
    make   "$@"
    unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
    oe_runmake
}


PACKAGES = "${PN}-noarch kernel-module-${PN} ${PN}-util ${PN}-util-dbg ${PN}-dev"

FILES_kernel-module-${PN} = " \
    ${base_libdir}/modules/${KERNEL_VERSION}/extra/mts_io.ko \
    ${sysconfdir}/modprobe.d/mts-io.conf \
"

FILES_${PN}-noarch = "${sysconfdir}/init.d/mts-io \
                        ${sysconfdir}/rc5.d/S95led-status_heartbeat_trigger \
                        ${sysconfdir}/default/mts-io  \
                        ${sysconfdir}/init.d/led-status_heartbeat_trigger"
                        
                        
FILES_${PN}-noarch += "${libdir}/mts-io-sysfs*"
FILES_${PN}-noarch += "${sbindir}/mts-io-sysfs"
FILES_${PN}-noarch_append_mtcap += "${sbindir}/lora-led-updater"
FILES_${PN}-util += "${sbindir}/mts-util-lora2-reset"
FILES_${PN}-util-dbg += "/usr/src /usr/sbin/.debug"
FILES_${PN}-dev += "${includedir}/linux ${includedir}/mts-kernel-headers"

INITSCRIPT_NAME = "mts-io"
INITSCRIPT_PARAMS = "start 39 S ."

PARALLEL_MAKE = ""

fakeroot do_install () {
    make DESTDIR=${D} install
    install -m 0755 -d ${D}${base_libdir}/modules/${KERNEL_VERSION}/extra
    # use cp instead of install so the driver doesn't get stripped
    cp ${S}/io-module/mts_io.ko ${D}${base_libdir}/modules/${KERNEL_VERSION}/extra

    # install headers for kernel modules
    install -d ${D}${includedir}/mts-kernel-headers/linux
    install -m 0644 ${S}/io-module/mts_io.h ${D}${includedir}/mts-kernel-headers/linux
    install -m 0644 ${S}/io-module/mts_eeprom.h ${D}${includedir}/mts-kernel-headers/linux
    install -m 0644 ${S}/io-module/at91gpio.h ${D}${includedir}/mts-kernel-headers/linux
    
    # install same headers for userspace applications
    # Note this dupication can be avoided by adding the following into the recipes
    #     CFLAGS += ${STAGING_INCDIR}/mts-kernel-headers
    #
    install -d ${D}${includedir}/linux
    install -m 0644 ${S}/io-module/mts_io.h ${D}${includedir}/linux
    install -m 0644 ${S}/io-module/mts_eeprom.h ${D}${includedir}/linux
    install -m 0644 ${S}/io-module/at91gpio.h ${D}${includedir}/linux

    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/mts-io.init ${D}${sysconfdir}/init.d/mts-io
    install -m 0755 ${WORKDIR}/led-status_heartbeat_trigger ${D}/${sysconfdir}/init.d/
    install -d ${D}${sysconfdir}/default
    install -m 0755 ${WORKDIR}/mts-io.conf ${D}${sysconfdir}/default/mts-io
    install -d ${D}${sysconfdir}/modprobe.d
    install -m 0644 ${WORKDIR}/mts-io.blacklist ${D}${sysconfdir}/modprobe.d/mts-io.conf

    # blink status LED after booted
    install -d ${D}${sysconfdir}/rc5.d
    ln -sf ${sysconfdir}/init.d/led-status_heartbeat_trigger ${D}/${sysconfdir}/rc5.d/S95led-status_heartbeat_trigger

    install -m 0755 -d ${D}${sbindir}
    install -d ${D}${libdir}/mts-io-sysfs
    install -m 0755 ${S}/io-tool/mts-io-sysfs-inc.sh ${D}${libdir}/mts-io-sysfs
    install -m 0755 ${S}/io-tool/mts-io-sysfs ${D}${sbindir}/mts-io-sysfs
}

fakeroot do_install_append_mtcap() {
    # install MTCAP mts-io init script
    install -m 0755 ${WORKDIR}/mts-io.mtcap.init ${D}${sysconfdir}/init.d/mts-io
    install -m 0755 ${WORKDIR}/lora-led-updater ${D}${sbindir}/lora-led-updater
}
