DESCRIPTION = "Cellular radio reset init scripts"
HOMEPAGE = "http://www.multitech.net/"
SECTION = "base"
PRIORITY = "optional"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/GPL-2.0;md5=801f80980d171dd6425610833a22dbe6"

SRC_URI = " \
    file://radio-reset.init \
    file://radio-reset.default \
"

inherit update-rc.d

INITSCRIPT_NAME = "radio-reset"

# The script starts with runlevel of 40 (right after mts-io) in initlevel S (Single-user mode on boot),
# and stops with runlevel of 99 in initlevel 6 (reboot)
INITSCRIPT_PARAMS = "start 40 S . stop 99 6 ."

do_install() {
  install -d ${D}/etc/init.d
  install -m 0755 ${WORKDIR}/radio-reset.init ${D}/etc/init.d/radio-reset

  install -d ${D}${sysconfdir}/default
  install -m 0644 ${WORKDIR}/radio-reset.default ${D}${sysconfdir}/default/radio-reset
}

fakeroot do_install_append_mtr() {
    # enable radio-reset on start for the mtr hardware
    sed -i 's/ONSTART="no"/ONSTART="yes"/g' ${D}${sysconfdir}/default/radio-reset

    # disable radio-reset on shutdown for the mtr hardware
    sed -i 's/ONSTOP="yes"/ONSTOP="no"/g' ${D}${sysconfdir}/default/radio-reset
}

fakeroot do_install_append_mtrv1() {
    # enable radio-reset on start for the mtrv1 hardware
    sed -i 's/ONSTART="no"/ONSTART="yes"/g' ${D}${sysconfdir}/default/radio-reset

    # disable radio-reset on shutdown for the mtrv1 hardware
    sed -i 's/ONSTOP="yes"/ONSTOP="no"/g' ${D}${sysconfdir}/default/radio-reset
}

fakeroot do_install_append_mtcap() {
    # disable radio-reset both on start and on shutdown for the mtcap hardware
    # mtcap issues the radio reset in /etc/init.d/mts-io init script
    sed -i 's/ENABLED="yes"/ENABLED="no"/g' ${D}${sysconfdir}/default/radio-reset
}
