DESCRIPTION = "The calibrator and other useful utilities for TI wireless solution based on wl12xx driver"
HOMEPAGE = "http://software-dl.ti.com/ecs/WiLink8/latest/index_FDS.html"
SECTION = "console/utils"
PRIORITY = "optional"
LICENSE = "BSD"
LIC_FILES_CHKSUM = "file://${COREBASE}/meta/files/common-licenses/BSD;md5=3775480a712fc46a69647678acb234cb"
DEPENDS = "libnl"
# ti-compat-wireless-wl12xx
RDEPENDS_${PN} = "wl12xx-firmware"

inherit autotools-brokensep

do_compile () {
   unset CFLAGS LDFLAGS CXXFLAGS CPPFLAGS
   # For Newer Yocto/Bitbake, CC does not
   # include the staging directory
   # by default
   CC="${CC} --sysroot=${STAGING_DIR_HOST}"
   LD="${LD} --sysroot=${STAGING_DIR_HOST}"
   oe_runmake CC="${CC}" LD="${LD}"
}

PR = "r2"
# tag R8.7
SRCREV = "39542357111d1f24e866c2857d561a348c04cce4"

SRC_URI = " \
        git://git.ti.com/wilink8-wlan/18xx-ti-utils.git;protocol=git;branch=master \
        file://upgrade_libnl_to_32.patch \
        file://plt_drop_insmod_rmmod.patch "



S = "${WORKDIR}/git"

export CROSS_COMPILE = "${TARGET_PREFIX}"

do_install() {
	install -d ${D}${bindir}
	install -d ${D}${datadir}/ti/wifi-utils/ini_files/127x
	install -d ${D}${datadir}/ti/wifi-utils/ini_files/128x

	install -m 0755 calibrator ${D}${bindir}/
	install -m 0755 ${S}/hw/ini_files/127x/* ${D}${datadir}/ti/wifi-utils/ini_files/127x
	install -m 0755 ${S}/hw/ini_files/128x/* ${D}${datadir}/ti/wifi-utils/ini_files/128x
}

FILES_${PN} += " \
	${datadir}/ti/wifi-utils/ini_files/127x \
	${datadir}/ti/wifi-utils/ini_files/128x \
"
