require u-boot_2018.07.inc
HOMEPAGE = "http://www.denx.de/wiki/U-Boot/WebHome"
SECTION = "bootloaders"
DEPENDS += "flex-native bison-native dtc-native"

LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://Licenses/README;md5=30503fd321432fc713238f582193b78e"
PE = "1"

# We use the revision in order to avoid having to fetch it from the
# repo during parse
SRCREV = "8c5d4fd0ec222701598a27b26ab7265d4cee45a3"

SRC_URI = "git://git.denx.de/u-boot.git \
           file://CVE-2018-1000205-1.patch \
           file://CVE-2018-1000205-2.patch \
           file://i2c.patch \
"

# Software ECC version for beta release
SRC_URI_append_betamt100eocg = " \
           file://device-tree-files-mt100eocg.patch \
           file://0001-config-mt100eocg.patch \
           file://board-mt100eocg.patch \
           file://0002-config-mac-eth-random-mt100eocg.patch \
"

# Random MAC should be replaced by I2C EEPROM MAC
# just like MTR.
SRC_URI_append_mt100eocg = " \
           file://device-tree-files-mt100eocg.patch \
           file://0001-atmel_micron_ecc-sweccmt100eocg.patch \
           file://0002-atmel_nand_default_Micron.patch \
           file://0001-config-mt100eocg.patch \
           file://board-mt100eocg.patch \
           file://0002-config-wdt-mt100eocg.patch \
"

# sweccmt100eocg has at91bootstrap using Hamming code ECC
# and U-Boot has On-Die ECC capability
SRC_URI_append_sweccmt100eocg = " \
           file://device-tree-files-mt100eocg.patch \
           file://0001-atmel_micron_ecc-sweccmt100eocg.patch \
           file://0002-atmel_nand_default_Hamming.patch \
           file://0001-config-mt100eocg.patch \
           file://0002-config-sweccmt100eocg.patch \
           file://board-mt100eocg.patch \
"



S = "${WORKDIR}/git"

#           file://0002-config-sweccmt100eocg.patch
