DESCRIPTION = "TI wl1271 firmware"
HOMEPAGE = "http://processors.wiki.ti.com/index.php/ARM_Processor_Open_Source_Wireless_Connectivity"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=1c9961176d6529283e0d0c983be41b45"
PR="r9"

# bluetooth firmware from TI-ECS on github.com:
# https://github.com/TI-ECS/bt-firmware.git
# revision 3c0e4752ba91be195ac05226725428dfdc1a4759
# Last file log message: "Updated to service pack 2.14"
# file: am335x/TIInit_7.6.15.bts
# md5sum: a46c46104c7fab23bb9ebfae1633a3af
# wifi firmware from Wkennington on github.com
# https://github.com/wkennington/linux-firmware/tree/master/ti-connectivity
# revision 6d3bc8886517d171068fd1263176b8b5c51df204
# Last file log message: "Fix permissions on ti-connectivity firmware from 05e9fe5 Signed-off-by: Kyle McMartin <kyle@kernel.org>"
# file: ti-connectivity/wl127x-fw-5-sr.bin
# file: ti-connectivity/wl127x-fw-5-mr.bin
# file: ti-connectivity/wl127x-fw-5-plt.bin

SRC_URI = "file://wl127x-fw-5-mr.bin \
           file://wl127x-fw-5-plt.bin \
           file://wl127x-fw-5-sr.bin \
           file://TIInit_7.6.15.bts \
           file://wl1271-nvs.bin \
           file://calibrate-wifi \
           file://LICENSE "

# nothing to compile
do_configure() {
}

do_compile() {
}

do_install() {
	install -d ${D}/lib/firmware
	install -d ${D}/sbin
	install -d ${D}/lib/firmware/ti-connectivity
	# wifi firmware
	install ${WORKDIR}/wl127x-fw-*-*.bin ${D}/lib/firmware/ti-connectivity
	# uncalibrated nvs file
	# use local copy since the one in hw/firmware dir is *wrong*
	install ${WORKDIR}/wl1271-nvs.bin ${D}/lib/firmware/ti-connectivity/wl1271-nvs.bin.factory
	# link to nvs file with mac address set
	ln -sf /var/oem/mts/wl1271-nvs.bin ${D}/lib/firmware/ti-connectivity/wl127x-nvs.bin
	install ${WORKDIR}/calibrate-wifi ${D}/sbin
	# bluetooth firmware
	install ${WORKDIR}/TIInit_7.6.15.bts ${D}/lib/firmware/ti-connectivity/TIInit_7.6.15.bts
}

FILES_${PN} = "/lib/firmware /sbin"
