SUMMARY = "Device Tree Compiler and its library"
HOMEPAGE = "https://git.kernel.org/pub/scm/utils/dtc/dtc.git/about/"
LICENSE = "BSD & GPLv2+"
LIC_FILES_CHKSUM = "file://README.license;md5=89fd4e63f2aea733216e660f81b3c118"

SRC_URI = "git://git.kernel.org/pub/scm/utils/dtc/dtc.git"
SRCREV = "78e113e81c9d33d0f33704b187a46399d5a75419"
INC_PR = "r1"
PR = "${INC_PR}.0"
DEPENDS = "flex bison swig"
RDEPENDS_dtc = "libfdt"
S = "${WORKDIR}/git"
PACKAGES =+ "libfdt"
FILES_libfdt = "${libdir}/libfdt.so.[0-9] ${libdir}/libfdt-*.so"
RPROVIDES_libfdt = "libfdt"

FILES_${PN}-dev += "${libdir}/libfdt.so.[0-9].*"

do_compile() {
        oe_runmake
}

do_install() {
    echo "DESTDIR is ${D}"
    oe_runmake install-lib DESTDIR=${D} HOME="/" LIBDIR="${libdir}"
    install -d ${D}/${includedir}/libfdt
    install ${S}/libfdt/*.h ${D}/${includedir}/libfdt
}
