# Recipe to produce a static nandwrite for flashing 
# the root file system after it has been mounted
# read-only, and erased on the flash.
# nanderase has already loaded its libraries before
# the root file system has been erased, so it
# does not need to be static.
require recipes-devtools/mtd/mtd-utils_git.bb

FILESEXTRAPATHS_prepend := "${THISDIR}/mtd-utils:"

PR = "r0"

PACKAGES = "${PN} ${PN}-dbg"

# build static version of nandwrite for flash upgrading
CFLAGS += "-static"

do_install () {
	install -d ${D}${bindir}
	install -m 0755 ${B}/nandwrite.static ${D}${bindir}/
}

do_compile_append() {
    ${CC} ${CFLAGS} ${LDFLAGS} -o nandwrite.static nand-utils/nandwrite.o libmtd.a
}