# AUTOLOADs are in inc files now.
require driver.inc
require crypto.inc
require net.inc

SECTION = "kernel"
DESCRIPTION = "Linux kernel for Atmel ARM SoCs (aka AT91)"
SUMMARY = "Linux kernel for Atmel ARM SoCs (aka AT91)"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=bbea815ee2795b2f4230826c0c6b8814"

inherit kernel
# mts class to build dtb and append to kernel image
inherit linux-append-dtb


RDEPENDS_kernel-base=""
FILESEXTRAPATHS_prepend := "${THISDIR}/${P}:"
KERNEL_EXTRA_ARGS ="LOADADDR=0x20008000"

PR = "r12"
KERNEL_VERSION = "${PV}"
EXTRAVERSION = ""

SAMV = "linux4sam_6.2-icp"
S = "${WORKDIR}/linux-at91-${SAMV}"

SRCREV = "27484da9a85074f49d23cdf1d3de75c70520336b"

BRANCH ?= "master"
#SRC_URI = "file:///home/user/job/OCG/linux-at91"
#S = "${WORKDIR}/home/user/job/OCG/linux-at91"

#SRC_URI = "git://github.com/linux4sam/linux-at91.git;protocol=git;branch=${BRANCH}"
SRC_URI = "https://github.com/linux4sam/linux-at91/archive/${SAMV}.tar.gz"
SRC_URI[md5sum] = "a1935730b6663f69f3efbb1950c4f1b7"
SRC_URI[sha256sum] = "da4d30bee7473cd6fa50d5c51341f930dac0c1343a2ea9f65f0fa50711757cb7"

COMMON_PATCHES = " \
		  file://defconfig \
		  file://EXTRAVERSION.patch \
		 "

SRC_URI_append_mt100eocg = "\
            ${COMMON_PATCHES} \
            file://linux-4.19-mt100eocg-device-tree.patch \
            file://micron-ondie.patch \
	    file://nand_micron-driver.patch \
            "
SRC_URI_append_betamt100eocg = "\
            ${COMMON_PATCHES} \
            file://linux-4.19-betamt100eocg-device-tree.patch \
            "

KERNEL_MODULE_AUTOLOAD_mtcap_append += "i2c-dev"
KERNEL_MODULE_AUTOLOAD_mtcdt_append += "i2c-dev"
KERNEL_MODULE_AUTOLOAD_mt100eocg_append += "i2c-dev"
KERNEL_MODULE_AUTOLOAD_betamt100eocg_append += "i2c-dev"

DTB_APPEND_mtcdt = "mtcdt"
DTB_APPEND_mtrv1 = "mtrv1"
DTB_APPEND_mtcap = "mtcap"
DTB_APPEND_mtr = "mtr"
DTB_APPEND_mt100eocg = "mt100eocg"
DTB_APPEND_betamt100eocg = "mt100eocg"

python __anonymous () {
	if d.getVar('UBOOT_FIT_IMAGE', True) == 'xyes':
		d.appendVar('DEPENDS', ' u-boot-mkimage-native dtc-native')
}

do_deploy_append() {
	if [ "${UBOOT_FIT_IMAGE}" = "xyes" ]; then
		DTB_PATH="${B}/arch/${ARCH}/boot/dts/"
		if [ ! -e "${DTB_PATH}" ]; then
			DTB_PATH="${B}/arch/${ARCH}/boot/"
		fi

		if [ -e ${S}/arch/${ARCH}/boot/dts/${MACHINE}.its ]; then
			cp ${S}/arch/${ARCH}/boot/dts/${MACHINE}*.its ${DTB_PATH}
			cd ${DTB_PATH}
			mkimage -f ${MACHINE}.its ${MACHINE}.itb
			install -m 0644 ${MACHINE}.itb ${DEPLOYDIR}/${MACHINE}.itb
			cd -
		fi
	fi
}

kernel_do_configure_append() {
	rm -f ${B}/.scmversion ${S}/.scmversion
	cd ${S}; git status; cd -
}

KERNEL_MODULE_PACKAGE_SUFFIX=""

COMPATIBLE_MACHINE = "(mtcdt|mtrv1|mtr|mtcap|mths|mt100eocg|betamt100eocg)"

pkg_preinst_kernel-image-uimage() {
    set -x
    mkdir -m 0755 /var/volatile/boot 2>/dev/null || true
    ls /boot || true
    ls -l /boot | true
    rm -rf /boot
    ln -sf /var/volatile/boot /boot 2>/dev/null || true
}

pkg_prerm_kernel-image-uimage() {
        rm -rf /var/volatile/boot || true
        rm -rf /boot || true
}

PACKAGES =+ "kernel-image-uimage-inst kernel-dt-bindings-dev"
# Not sure how to get the name below generated automatically
RDEPENDS_kernel-image-uimage-inst += "kernel-image-uimage-${PV}"
ALLOW_EMPTY_kernel-image-uimage-inst = "1"

pkg_postinst_kernel-image-uimage-inst() {
	# Only installs all the kernel on the device (D is defined in bitbake)
	if [[ -z "$D" ]] ; then
	    logger -s -p user.info -t opkg "Upgrading kernel ${PV} -- poweroff will create an unbootable device"
	    set -x
	    kernel_mtd="/dev/$(cat /proc/mtd | grep '\"uImage\"' | cut -d : -f 1)"
	    flash_erase ${kernel_mtd} 0 0
	    if nandwrite -p ${kernel_mtd} /boot/uImage-${PV} ; then
                echo 'Kernel image update is successful'
            fi
	    set +x
	fi
}

do_install_append() {
        install -d -m 0755  ${D}${includedir}/linux
        cp -a ${STAGING_KERNEL_DIR}/include/dt-bindings ${D}${includedir}/linux/
        install -d -m 0755 ${STAGING_DIR_TARGET}/${includedir}/linux
        cp -a ${STAGING_KERNEL_DIR}/include/dt-bindings ${STAGING_DIR_TARGET}/${includedir}/linux
}

FILES_kernel-dt-bindings-dev = "/usr/include/linux/dt-bindings"
