# AUTOLOADs are in inc files now.
require driver.inc
require crypto.inc
require net.inc

SECTION = "kernel"
DESCRIPTION = "Linux kernel for Atmel ARM SoCs (aka AT91)"
SUMMARY = "Linux kernel for Atmel ARM SoCs (aka AT91)"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=d7810fab7487fb0aad327b76f1be7cd7"

inherit kernel
# mts class to build dtb and append to kernel image
inherit linux-append-dtb


RDEPENDS_kernel-base=""
FILESEXTRAPATHS_prepend := "${THISDIR}/${P}:"
KERNEL_EXTRA_ARGS ="LOADADDR=0x20008000"

PR = "r12"
KERNEL_VERSION = "${PV}"
EXTRAVERSION = ""

SAMV = "linux4sam_5.8"
S = "${WORKDIR}/linux-at91-${SAMV}"

SRCREV = "29796588eb6a4c89795baaea3035764d15d0e44a"

KBRANCH = "linux-4.9-at91"
#SRC_URI = "git://github.com/linux4sam/linux-at91.git;protocol=git;branch=${KBRANCH}"
SRC_URI = "https://github.com/linux4sam/linux-at91/archive/${SAMV}.tar.gz"
SRC_URI[md5sum] = "09002b6b7e5a654d65ddf3fcc9574add"
SRC_URI[sha256sum] = "eaff5fdba506bef95ca57db1a53e19b6807bc9b090f97d3348b1712708c32d4e"

COMMON_PATCHES = " \
		  file://defconfig \
		  file://linux-4.9-pps-gpio.patch \
		  file://linux-4.9-at91sam9_wdt-10second-timeout.patch \
                  file://linux-4.9-spidev_squack.patch \
                  file://linux-4.9-add-num_accessory_ports-config-option.patch \
                  file://linux-4.9-cdc-acm-ignore-exar-devices.patch \
		  file://EXTRAVERSION.patch \
		  file://linux-4.9-ledtrig-netdev.patch \
		  file://linux-4.9-telit_print_qmi_wwan.patch \
		  file://linux-4.9-addl-time-for-pmeccerrloc.patch \
		  file://950-0090-OF-DT-Overlay-configfs-interface.patch \
		  file://linux-4.9-led-core-Fix-brightness-setting-when-setting-delay_off-0.patch \
		  file://linux-4.9-linux4sam-usb-serial-option.patch \
		  file://linux-4.9-quectel_qmi_wwan_support.patch \
		 "


SRC_URI_append_mtcdt = "\
            ${COMMON_PATCHES} \
            file://linux-4.9-mtcdt-device-tree.patch \
            "
SRC_URI_append_mtrv1 = "\
            ${COMMON_PATCHES} \
            file://linux-4.9-mtrv1-device-tree.patch \
            "
SRC_URI_append_mtcap = "\
            ${COMMON_PATCHES} \
            file://linux-4.9-mtcap-device-tree.patch \
            "
SRC_URI_append_mtr = "\
            ${COMMON_PATCHES} \
            file://linux-4.9-mtr-device-tree.patch \
            file://fix-atmel-mci-reg-overloading.patch \
            file://wl12xx_enable_disable.patch \
            "
SRC_URI_append_mt100eocg = "\
            ${COMMON_PATCHES} \
            file://linux-4.9-spi-atmel-Fix-crash-when-using-more-than-4-gpio-CS.patch \
            file://linux-4.9-mt100eocg-device-tree.patch \
            "

KERNEL_MODULE_AUTOLOAD_mtcap_append += "i2c-dev"
KERNEL_MODULE_AUTOLOAD_mtcdt_append += "i2c-dev"
KERNEL_MODULE_AUTOLOAD_mt100eocg_append += "i2c-dev"

DTB_APPEND_mtcdt = "mtcdt"
DTB_APPEND_mtrv1 = "mtrv1"
DTB_APPEND_mtcap = "mtcap"
DTB_APPEND_mtr = "mtr"
DTB_APPEND_mt100eocg = "mt100eocg"

python __anonymous () {
	if d.getVar('UBOOT_FIT_IMAGE', True) == 'xyes':
		d.appendVar('DEPENDS', ' u-boot-mkimage-native dtc-native')
}

do_deploy_append() {
	if [ "${UBOOT_FIT_IMAGE}" = "xyes" ]; then
		DTB_PATH="${B}/arch/${ARCH}/boot/dts/"
		if [ ! -e "${DTB_PATH}" ]; then
			DTB_PATH="${B}/arch/${ARCH}/boot/"
		fi

		if [ -e ${S}/arch/${ARCH}/boot/dts/${MACHINE}.its ]; then
			cp ${S}/arch/${ARCH}/boot/dts/${MACHINE}*.its ${DTB_PATH}
			cd ${DTB_PATH}
			mkimage -f ${MACHINE}.its ${MACHINE}.itb
			install -m 0644 ${MACHINE}.itb ${DEPLOYDIR}/${MACHINE}.itb
			cd -
		fi
	fi
}

kernel_do_configure_append() {
	rm -f ${B}/.scmversion ${S}/.scmversion
	cd ${S}; git status; cd -
}

KERNEL_MODULE_PACKAGE_SUFFIX=""

COMPATIBLE_MACHINE = "(mtcdt|mtrv1|mtr|mtcap|mths|mt100eocg)"

pkg_preinst_kernel-image-uimage() {
    set -x
    mkdir -m 0755 /var/volatile/boot 2>/dev/null || true
    ls /boot || true
    ls -l /boot | true
    rm -rf /boot
    ln -sf /var/volatile/boot /boot 2>/dev/null || true
}

pkg_prerm_kernel-image-uimage() {
        rm -rf /var/volatile/boot || true
        rm -rf /boot || true
}

PACKAGES =+ "kernel-image-uimage-inst kernel-dt-bindings-dev"
# Not sure how to get the name below generated automatically
RDEPENDS_kernel-image-uimage-inst += "kernel-image-uimage-${PV}"
ALLOW_EMPTY_kernel-image-uimage-inst = "1"

pkg_postinst_kernel-image-uimage-inst() {
	# Only installs all the kernel on the device (D is defined in bitbake)
	if [[ -z "$D" ]] ; then
	    logger -s -p user.info -t opkg "Upgrading kernel ${PV} -- poweroff will create an unbootable device"
	    set -x
	    kernel_mtd="/dev/$(cat /proc/mtd | grep '\"uImage\"' | cut -d : -f 1)"
	    flash_erase ${kernel_mtd} 0 0
	    if nandwrite -p ${kernel_mtd} /boot/uImage-${PV} ; then
                echo 'Kernel image update is successful'
            fi
	    set +x
	fi
}

do_install_append() {
        install -d -m 0755  ${D}${includedir}/linux
        cp -a ${STAGING_KERNEL_DIR}/include/dt-bindings ${D}${includedir}/linux/
        install -d -m 0755 ${STAGING_DIR_TARGET}/${includedir}/linux
        cp -a ${STAGING_KERNEL_DIR}/include/dt-bindings ${STAGING_DIR_TARGET}/${includedir}/linux
}

FILES_kernel-dt-bindings-dev = "/usr/include/linux/dt-bindings"
