inherit kernel
# mts class to build dtb and append to kernel image
inherit linux-append-dtb

PR = "r20"
# Example for adding a revision to a kernel module:
# PR_kernel-module-bluetooth = "${PR}.m1"

LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=d7810fab7487fb0aad327b76f1be7cd7"

DEPENDS += "xz-native bc-native"

SRC_URI = "https://www.kernel.org/pub/linux/kernel/v3.x/linux-${PV}.tar.gz \
"

S = "${WORKDIR}/${PN}-${PV}"

COMMON_PATCHES = " \
            file://linux-3.12-gpio-expose-pullups.patch \
            file://linux-3.12-gpio-expose-deglitch.patch \
            file://linux-3.12-atmel-spi.patch \
            file://linux-3.12-atmel-mci-force-detect.patch \
            file://linux-3.12-atmel-pmecc-debug-bitflips.patch \
            file://linux-3.12-at91sam9_wdt-10second-timeout.patch \
            file://linux-3.12-option-telit.patch \
            file://linux-3.12-cdc-acm-ignore-exar-devices.patch \
            file://linux-3.12-release-rfcomm-port-fix.patch \
            file://linux-3.12-spi-atmel-dma-min.patch \
            file://linux-3.12-pps-gpio.patch \
	    file://linux-3.12-cadence-macb.patch \
            file://bluetooth_l2cap.patch \
            "

SRC_URI_append_mtcdt = "\
            ${COMMON_PATCHES} \
            file://defconfig \
            file://linux-3.12-eeprom-setup-mtcdt.patch \
            file://linux-3.12-mtcdt-device-tree.patch \
            file://linux-3.12-add-num_accessory_ports-config-option.patch \
            "

SRC_URI_append_mtcap = "\
            ${COMMON_PATCHES} \
            file://defconfig \
            file://linux-3.12-eeprom-setup-mtcdt.patch \
            file://linux-3.12-mtcap-device-tree.patch \
            file://linux-3.12-add-num_accessory_ports-config-option.patch \
            "

SRC_URI_append_mtr = "\
            ${COMMON_PATCHES} \
            file://defconfig \
            file://linux-3.12-eeprom-setup-mtr.patch \
            file://linux-3.12-mtr-device-tree.patch \
            file://linux-3.12-add-num_accessory_ports-config-option.patch \
            file://linux-3.12-wl12xx-fix-threaded-irq-requested-with-NULL-handler.patch \
            file://linux-3.12-wl12xx-set-power.patch \
            file://linux-3.12-wl12xx-fix-boot-in-plt-mode.patch \
            file://linux-3.12-ledtrig-netdev.patch "

SRC_URI_append_mtrv1 = "\
            ${COMMON_PATCHES} \
            file://defconfig \
            file://linux-3.12-eeprom-setup-mtr.patch \
            file://linux-3.12-mtrv1-device-tree.patch \
            file://linux-3.12-add-num_accessory_ports-config-option.patch \
            file://linux-3.12-wl12xx-fix-threaded-irq-requested-with-NULL-handler.patch \
            file://linux-3.12-wl12xx-set-power.patch \
            file://linux-3.12-wl12xx-fix-boot-in-plt-mode.patch \
            file://linux-3.12-ledtrig-netdev.patch "


SRC_URI[md5sum] = "84b573a1583079df1e770210daa6c525"
SRC_URI[sha256sum] = "af56c7ba98a0ba0c3722d9ec7106830996610e6fd88e4b0c6b2b92dab88d7653"

COMPATIBLE_MACHINE = "(mtcdt|mtcap|mtr|mtrv1)"
DTB_APPEND_mtcdt = "mtcdt"
DTB_APPEND_mtcap = "mtcap"
DTB_APPEND_mtr = "mtr"
DTB_APPEND_mtrv1 = "mtrv1"

# disable this on purpose for dev purposes
do_rm_work() {
	echo "skipping"
}


pkg_preinst_kernel-image-uimage() {
    set -x
    mkdir -m 0755 /var/volatile/boot 2>/dev/null || true
    ls /boot || true
    ls -l /boot | true
    rm -rf /boot
    ln -sf /var/volatile/boot /boot 2>/dev/null || true
}

pkg_prerm_kernel-image-uimage() {
        rm -rf /var/volatile/boot || true
        rm -rf /boot || true
}

PACKAGES =+ "kernel-image-uimage-inst"
RDEPENDS_kernel-image-uimage-inst += "kernel-image-uimage-${PV}"
ALLOW_EMPTY_kernel-image-uimage-inst = "1"

pkg_postinst_kernel-image-uimage-inst() {
	# Only installs all the kernel on the device (D is defined in bitbake)
	if [[ -z "$D" ]] ; then
	    logger -s -p user.info -t opkg "Upgrading kernel ${PV} -- poweroff will create an unbootable device"
	    set -x
	    kernel_mtd="/dev/$(cat /proc/mtd | grep '\"uImage\"' | cut -d : -f 1)"
	    flash_erase ${kernel_mtd} 0 0
	    if nandwrite -p ${kernel_mtd} /boot/uImage-${PV} ; then
                echo 'Kernel image update is successful'
            fi
	    set +x
	fi
}
