#!/bin/bash
ADDR=$1
CHAN=$2
BTPIDFILE=/opt/immunity/btpid
file=btfile
OFTP=/usr/bin/obexftp
cd /opt/immunity
if ! [[ -r $file ]] ; then
  echo "Must have file $file for bluetooth testing."
  exit 1
fi
  

if ! [[ -x $OFTP ]] ; then
    echo Need to install $OFTP
    exit 1
fi
while ((${#CHAN} == 0)) ; do
  hciconfig hci0 up
  scanlist=""
  scanlist+=$(hcitool scan)
  sleep 2
  scanlist+=$(hcitool scan)
  sleep 3
  scanlist+=$(hcitool scan)
  echo "hcitool scan result"
  echo "${scanlist}"
  list=($(echo "${scanlist}" | grep ':' | sed -r -e 's/^[[:space:]]*//' -e 's/[[:space:]].*//' | sort | uniq))
  
  ((i=0))
  ((quit=0))
  while((i<${#list[@]})) ; do
      # Look for OBEX Object push
      echo "Browse list[$i]=${list[$i]}"
      ((quit=0))
      ((j=0))
      while : ; do
	services=$(sdptool browse ${list[$i]})
	if (($?==0)) ; then
	  echo Listing services
	  echo "$services"
	  ADDR=${list[$i]}
	  break;
	fi
	echo "$services"
	((j++))
	if ((j>5)) ; then
	  echo "Giving up on ${list[$i]}"
	  ((quit=1))
	  break;
	fi
	sleep 1
      done # Looping while running sdptool
      ((i++))
      if((quit)); then
	continue
      fi
      if ((${#services}==0)) ; then
	continue;
      fi
      echo "$services" >/tmp/services.txt
      CHAN=$(echo "${services}" | grep -A11 'OBEX Object Push' | grep 'Channel:' | sed 's/[[:space:]]*Channel:[[:space:]]*//')
      if ((${#CHAN})) ; then
	  echo found channel $CHAN
	  break;
      fi # Found a channel
  done # Loop through Bluetooth addresses
done # Channel parameter not specified

if ((${#CHAN} == 0)) ; then
    echo Could not find an OBEX Object push service
    echo 'please do:'
    echo '    bluetoothXfer.sh Address Channel'
    exit 1
fi
echo Copying file $file to Address $ADDR Channel $CHAN repeatedly
((failcnt=0))
while : ; do
  echo $$ >$BTPIDFILE
  if time obexftp -SH -b "$ADDR" -B "$CHAN" -U none -p btfile ; then
    ((failcnt=0))
  else
    ((failcnt++))
    echo Failed to transfer file $failcnt times in a row.
    echo -- obexftp -SH -b "$ADDR" -B "$CHAN" -U none -p btfile
    sleep 2
  fi
done
exit 0
