#!/bin/bash
: ${WPA_CONFIG:=/etc/wpa_supplicant/wifitest.conf}
URL=$1
if ((${#URL} == 0)) ; then
    URL='http://www.multitech.net/mlinux/feeds/3.2/arm926ejste/nodejs-dbg_0.10.44-r1.3.0_arm926ejste.ipk'
fi

if [[ $URL == wifisetup ]] ; then
    wifisetup=true
else
    wifisetup=false
fi

FILE=$2
if ((${#FILE} == 0)) ; then
    FILE='nodejs-dbg_0.10.44-r1.3.0_arm926ejste.ipk'
fi
ifdown wifi0

if ! [[ -r  ${WPA_CONFIG} ]] ; then
    echo Missing wifi configuration file $WPA_CONFIG
    exit 1
fi

/opt/rs9113/onebox_util rpine0 enable_protocol 3
sleep 3
/opt/rs9113/onebox_util rpine0 set_country 840
sleep 3
/opt/rs9113/onebox_util rpine0 create_vap wifi0 sta sw_bmiss

if $wifisetup ; then
   sleep 3
   ifup wifi0
   sleep 3
   # So iwlist scan will work.
   # iw does not have good signal strenght values.
   iw dev wifi0 scan >/dev/null 2>&1
   exit 0
else
  supplicant=$(ps -o args,pid -e | grep wpa_supplicant | grep -v grep | sed -r 's/.*[[:space:]]([0-9]*)$/\1/')
  if ((${#supplicant})) ; then\
      kill ${supplicant}
      sleep 2
  fi
  echo Pre start of supplicant
  ps -ef | grep wpa_supplicant
  sleep 2
  /usr/sbin/wpa_supplicant -B -i wifi0 -D nl80211 -c "${WPA_CONFIG}"
  echo Post start of supplicant
  ps -ef | grep wpa_supplicant
  sleep 2
  while ! ifup wifi0 ; do
    sleep 1
  done
fi
sleep 2
((count=0))
cd /var/volatile
echo Downloading file $FILE from Address $URL repeatedly
rm -f ${FILE}*
while time wget "${URL}" ; do rm -f ${FILE}* ; done
exit 0
