DESCRIPTION = "USB Driver for Redpine RS9113"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"
PROVIDES = "rs9113-from-src"
PR = "r10.${MLINUX_KERNEL_VERSION}${MLINUX_KERNEL_EXTRA_VERSION}"
INHIBIT_PACKAGE_STRIP = "1"
BB_STRICT_CHECKSUM = "0"
inherit module

SRCREV = "${AUTOREV}"

SRC_URI = " \
        git://git@${MTS_INTERNAL_GIT}/mlinux/meta-rs9113.git;protocol=ssh;branch=${PV};destsuffix=meta/ \
        git://git@${MTS_INTERNAL_GIT}/mlinux/Redpine.git;protocol=ssh;branch=${PV} \
"
SRCXX_URI = " \
    git://git@${MTS_INTERNAL_GIT}/mlinux/Redpine.git;protocol=ssh;branch=${PV};name=machine \
    git://git@${MTS_INTERNAL_GIT}/mlinux/meta-rs9113.git;protocol=ssh;branch=${PV};name=meta \
"

S = "${WORKDIR}/git/source/host"
M = "${WORKDIR}/meta"

EXTRA_OEMAKE = " KERNELDIR=${STAGING_KERNEL_DIR} \
                 CROSS_COMPILE=${TARGET_PREFIX} \
                 ARCH=arm \
                 WLAN_COMPILE_FLAGS='' \
		 V=1 \
                "
                
FILES_${PN} = "/opt/rs9113 ${sbindir}"
FILES_${PN}-dbg = "/opt/rs9113/.debug/"

PARALLEL_MAKE = ""

# Avoid QA Issue: No GNU_HASH in the elf binary
INSANE_SKIP_${PN} = "ldflags"
INSANE_SKIP_${PN}-dev = "ldflags" 

do_configure() {
   cp ${M}/${MACHINE}/defconfig .config
}

do_compile () {
   unset CFLAGS LDFLAGS CXXFLAGS CPPFLAGS
   # For Newer Yocto/Bitbake, CC does not
   # include the staging directory
   # by default
   CC="${CC} --sysroot=${STAGING_DIR_HOST}"
   LD="${LD} --sysroot=${STAGING_DIR_HOST}"
   oe_runmake CC="${CC}" LD="${LD}"
}

do_patch () {
	cd ${WORKDIR}/git
	for f in ${M}/patches/* ; do
          # Cannot use [[ $f =~ \.patch$ ]] here because the $ after patch breaks the recipe.
          if echo ${f} | grep '\.patch$' >/dev/null 2>&1 ; then
            echo found patch ${f}
            patch -Np1 < ${f}
          else
            fname=$(basename ${f})
            oldf=$(find . -name ${fname})
            echo "copying $f to ${oldf}"
            cp ${f} ${oldf}
          fi
	done
}

do_install() {
   echo D is ${D}
   install -m 0755 -d ${D}/opt/rs9113
   cp -r ${S}/release/* ${D}/opt/rs9113/
   rm -rf ${D}/opt/rs9113/flash ${D}/opt/rs9113/certs ${D}/opt/rs9113/*zigb*
   install -m 0755 -d ${D}${sbindir}
   install -m 0755 ${M}/rs9113_load_modules.sh ${D}${sbindir}/
   install -m 0755 ${M}/rs9113_remove_modules.sh ${D}${sbindir}/
   # New patch makes p2commands.sh a bash script.
   cd ${D}/opt/rs9113/
   mv p2pcommands.pl p2pcommands.sh
   ln -sf p2pcommands.sh p2pcommands.pl
}

