inherit update-rc.d
PACKAGE_ARCH = "${MACHINE_ARCH}"

# utils-extra picks up ELF executables we don't want on most images.
# misc picks up non-ELF's we don't want on most images.
# kernel-module-rs9113 picks up the *.ko files.
# util contains the onebox utility for creating the VAP.
# noarch contains the init script and configuration for the driver and
# the firmware file (firmware/*.rps).

PACKAGES = "${PN}-utils-extra ${PN}-misc kernel-module-${PN} ${PN}-util ${PN}-dbg ${PN}-noarch ${PN}-autostart ${PN}-btclonly"
ALLOW_EMPTY_${PN}-autostart = "1"
PACKAGE_ARCH_${PN}-noarch = "all"
PACKAGE_ARCH_${PN}-misc = "all"
PACKAGE_ARCH_${PN}-autostart = "all"
PACKAGE_ARCH_${PN}-util = "${TUNE_PKGARCH}"
PACKAGE_ARCH_${PN}-utils-extra = "${TUNE_PKGARCH}"
PACKAGE_ARCH_${PN}-dbg = "${TUNE_PKGARCH}"
PACKAGE_ARCH_${PN}-btclonly = "all"
RDEPENDS_${PN}-noarch = "bash"
RDEPENDS_${PN}-misc = "bash"
RDEPENDS_${PN}-btclonly = "${PN}-noarch"

ALLOW_EMPTY_${PN}-btclonly = "1"

DR = "${DL_DIR}/rs9113-ipk"
FILESEXTRAPATHS_append := "${DR}:"

INITSCRIPT_PACKAGES = "${PN}-autostart"
INITSCRIPT_NAME_${PN}-autostart = "rs9113"
INITSCRIPT_PARAMS_${PN}-autostart = "start 50 S ."
RDEPENDS_${PN}-autostart = "${PN}-noarch"

BB_STRICT_CHECKSUM = "0"

# Avoid QA Issue: No GNU_HASH in the elf binary
INSANE_SKIP_${PN} = "ldflags"
INSANE_SKIP_${PN}-dev = "ldflags" 

python do_fetch_prepend () {
    # d.setVar('BB_STRICT_CHECKSUM',False)
    DR = d.getVar("DR",True)
    bb.note("DR is " + DR)

    ARCH = d.getVar("PACKAGE_ARCH",True)

    try:
        os.mkdir(DR,0o755)
    except OSError:
        pass
    try:
      ex = "export SSH_AUTH_SOCK=" + d.getVar("SSH_AUTH_SOCK",True)
    except TypeError:
      ex=":"
      bb.note("SSH_AUTH_SOCK not set.  SSH keys must not use a pass phrase")
    bb.note("export is " + ex)

    gt = "git archive -v --remote=git@"

    
    gitversion = d.getVar("PV",True)

    PV = gitversion
    PV += "-"
    try:
      PV += d.getVar("PR",True)
    except TypeError:
      bb.fatal("PR is missing from recipe")

    bb.note("PV is " + PV)

    ipkn = "rs9113-from-src_" + PV + ".0_" + ARCH + ".ipk"
    bb.note("ipkname is " + ipkn)
    bb.note ("ipk path is " + DR + "/" + ipkn)

    try:
      gt += d.getVar("MTS_INTERNAL_GIT",True)
    except TypeError:
      if os.path.isfile(DR + "/" + ipkn):
          return
      bb.fatal("Need " + DR + "/" + ipkn + " or set MTS_INTERNAL_GIT and add it to BB_ENV_EXTRAWHITE")

    gt += ":mlinux/ipk.git " + gitversion
    bb.note("git is " + gt)
    tar = "tar -vx --strip-components 1 -C " + DR + " rs9113/" + ipkn
    bb.note("tar is " + tar)
    os.system(ex + ";" + gt + "|" + tar)
}

# Required drivers for Bluetooth and WiFi
FILES_kernel-module-${PN} = " \
	/opt/rs9113/*.ko \
	"

# Required utility
FILES_${PN}-util = "/opt/rs9113/onebox_util"

FILES_${PN}-dbg = "/opt/rs9113/.debug/bt_bbp_utils \
	/opt/rs9113/.debug \
	"

# ELF files here are not normally installed on images.
FILES_${PN}-utils-extra = " \
	/opt/rs9113/zb* \
	/opt/rs9113/bt_transmit \
	/opt/rs9113/zb_transmit \
	/opt/rs9113/transmit \
	/opt/rs9113/transmit_packet \
	/opt/rs9113/bt_receive \
	/opt/rs9113/receive \
	/opt/rs9113/zb_util \
	/opt/rs9113/bt_util \
	/opt/rs9113/bbp_util \
	/opt/rs9113/zb_bbp_util \
	/opt/rs9113/bt_receive \
	/opt/rs9113/bt_bbp_utils \
	/opt/rs9113/sniffer_app \
	/opt/rs9113/START_RS9116_NBZ_D0N \
	"

# pmemdata is for upgrading rs9113 non-volatile firmware
# *.rps are firmware files for various modes of
# rs9113 or rs9116 operation.
# MODE_PER is for certification testing.
# ZIGBEE is not supported.
# Files here are not normally installed on images.
FILES_${PN}-misc = " \
	/opt/rs9113/firmware/RS9113_WLAN_BT_DUAL_MODE_PER.rps \
	/opt/rs9113/firmware/RS9113_ZIGBEE_ROUTER.rps \
	/opt/rs9113/firmware/RS9113_ZIGBEE_COORDINATOR.rps \
	/opt/rs9113/firmware/RS9113_WLAN_ZIGBEE.rps \
	/opt/rs9113/firmware/pmemdata* \
	/opt/rs9113/firmware/flash_content \
	/opt/rs9113/*RS9116* \
	/opt/rs9113/*.orig \
	/opt/rs9113/*.txt \
	/opt/rs9113/*.sh \
	/opt/rs9113/*.conf \
	/opt/rs9113/p2pcommands.pl \
	/opt/rs9113/*reg \
	/opt/rs9113/afe_spi \
	/opt/rs9113/init.d \
	"

CONFFILES_${PN}-noarch = "${sysconfdir}/default/"
FILES_${PN}-noarch = "/opt/rs9113/ ${sysconfdir}/init.d/ ${sysconfdir}/default/ ${prefix}/"

MR = "${WORKDIR}/rs9113"
do_install () {
   bbnote "pwd,ls: $(pwd) $(ls) WORKDIR is ${WORKDIR}"
   (
    cd ${WORKDIR}
    find etc -print0 | cpio --owner root:root -0 -pdum ${D}
    find usr -print0 | cpio --owner root:root -0 -pdum ${D}
    find opt -print0 | cpio --owner root:root -0 -pdum ${D}
   )
   install -d ${D}/opt/rs9113/init.d
   install -d ${D}${sysconfdir}/init.d/
   install -d ${D}${sysconfdir}/default/
   install -m 0755 ${MR}/wpa_supplicant ${D}/opt/rs9113/init.d
   install -m 0755 ${MR}/rs9113.init ${D}${sysconfdir}/init.d/rs9113
   install -m 0644 ${MR}/rs9113.default ${D}${sysconfdir}/default/rs9113
}

python do_cleanall_prepend () {
    bb.note("In do_clean_prepend")
    DR = d.getVar("DR",True)
    bb.note("About to delete " + DR)
    os.system("/bin/rm -rf " + DR)
}

# btclonly package sets Bluetooth Classic mode
pkg_postinst_${PN}-btclonly() {
        sed -i 's/^COEX_MODE=.*/COEX_MODE=4/' $D${sysconfdir}/default/rs9113
}

