require rs9113.inc
DESCRIPTION = "USB Driver for Redpine RS9113"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"
PROVIDES = "rs9113"
FILES_${PN} = "/opt/rs9113 ${sbindir} ${sysconfdir}"
RDEPENDS_${PN} += "bash"

# This bitbake recipe requires SSH_AUTH_SOCK to be set if ssh key pass
# phrases are used.  SSH_AUTH_SOCK is set by a keyserver,
# such as gnome-keyring-daemon or ssh-keyagent.

# NOTE: rs9113 binary is built with Jenkin's job using rs9113-from-src_${PV}.bb
# To update this, manually copy ipk from Jenkin's job to
#     git://git@${MTS_INTERNAL_GIT}/mlinux/ipk.git;protocol=ssh;branch=${PV}
#
PR = "r10.${MLINUX_KERNEL_VERSION}${MLINUX_KERNEL_EXTRA_VERSION}"
SRC_URI = " \
    file://rs9113/rs9113.init \
    file://rs9113/rs9113.default \
    file://rs9113/wpa_supplicant \
    file://rs9113-ipk/rs9113-from-src_${PV}-${PR}.0_${MACHINE}.ipk;name=binaries \
"
SRCREV = "${AUTOREV}"
# For some reason the md5sum and sha256sum are ignored
SRC_URI[binaries.md5sum] = "7c0f7badf5a2a3b3dacc790ff0a9ce55"
SRC_URI[binaries.sha256sum] = "2780d417295999724ada4a08e6a196aaca55324af24b404e0f9b2f2ea7d4d830"
