DESCRIPTION = "USB Driver for Exar USB UARTs"
HOMEPAGE = "http://www.exar.com/connectivity/uart-and-bridging-solutions/usb-uarts/xr21v1414"
SECTION = "base"
PRIORITY = "optional"
LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/GPL-2.0;md5=801f80980d171dd6425610833a22dbe6"

INC_PR = "r1"

SRC_URI = " \
    file://vizzini.init \
"

inherit module
inherit update-rc.d

EXTRA_OEMAKE = " -C ${STAGING_KERNEL_DIR} \
                M=${S} \
                modules \
                "

do_compile () {
    unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
    oe_runmake
}

PACKAGES = "${PN}"

FILES_${PN} = "${base_libdir}/modules/${KERNEL_VERSION}/extra/vizzini.ko"
FILES_${PN} += "${sysconfdir}/init.d/vizzini"

INITSCRIPT_NAME = "vizzini"
INITSCRIPT_PARAMS = "start 90 S ."

PARALLEL_MAKE = ""

do_install() {
   install -m 0755 -d ${D}${base_libdir}/modules/${KERNEL_VERSION}/extra
    # use cp instead of install so the driver doesn't get stripped
    cp ${S}/vizzini.ko ${D}${base_libdir}/modules/${KERNEL_VERSION}/extra
    cp ${S}/vizzini.h ${STAGING_KERNEL_DIR}/include/linux/
    cp ${S}/vizzini.h ${STAGING_INCDIR}/linux/
    cp ${S}/vzioctl.h ${STAGING_KERNEL_DIR}/include/linux/
    cp ${S}/vzioctl.h ${STAGING_INCDIR}/linux/

    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/vizzini.init ${D}${sysconfdir}/init.d/vizzini
}
