SUMMARY = "Provides a way to load and enumerate PKCS#11 modules"
LICENSE = "BSD"
LIC_FILES_CHKSUM = "file://COPYING;md5=02933887f609807fbb57aa4237d14a50"

inherit autotools gettext pkgconfig upstream-version-is-even gtk-doc

DEPENDS = "libtasn1 libffi"

SRC_URI = "http://p11-glue.freedesktop.org/releases/${BP}.tar.gz"
SRC_URI[md5sum] = "4e9bea1106628ffb820bdad24a819fac"
SRC_URI[sha256sum] = "ef3a339fcf6aa0e32c8c23f79ba7191e57312be2bda8b24e6d121c2670539a5c"

EXTRA_OECONF = "--without-trust-paths"

# This recipe does not use the standard gtk-doc m4 macros, and so the ./configure flags
# that control gtk-doc build are non-standard
EXTRA_OECONF_prepend_class-target = "${@bb.utils.contains('GTKDOC_ENABLED', 'True', '--enable-doc --enable-doc-html --disable-doc-pdf', \
                                                                                    '--disable-doc', d)} "

# When building native recipes, disable gtkdoc, as it is not necessary,
# pulls in additional dependencies, and makes build times longer
EXTRA_OECONF_prepend_class-native = "--disable-doc "
EXTRA_OECONF_prepend_class-nativesdk = "--disable-doc "

UNKNOWN_CONFIGURE_WHITELIST_append = " --enable-gtk-doc-html --disable-gtk-doc-pdf --enable-gtk-doc --disable-gtk-doc"

# p11-kit relies on these two being copied from source tree
# instead of being regenerated by gtkdoc-scan, but doesn't setup
# dependencies correctly when there is a parallel build. Let's pre-copy
# them instead.
do_compile_prepend () {
        cp ${S}/doc/manual/p11-kit-overrides.txt ${S}/doc/manual/p11-kit-sections.txt ${B}/doc/manual/
}

FILES_${PN} += " \
    ${libdir}/p11-kit-proxy.so \
    ${libdir}/pkcs11/*.so \
    ${libdir}/pkcs11/*.la"

# PN contains p11-kit-proxy.so, a symlink to a loadable module
INSANE_SKIP_${PN} = "dev-so"
