%define	with_python_subpackage	1%{nil}
%define	with_python_version	2.6%{nil}
#%%define	with_perl_subpackage	1%{nil}
%define	with_perl_subpackage	0%{nil}
%define	with_bzip2		yes%{nil}
%define	with_xz			yes%{nil}
%define	with_apidocs		1%{nil}

%{!?_usrlibrpm:%global _usrlibrpm /usr/lib/rpm}
%{!?_rpmhome:%global _rpmhome /usr/lib/rpm}

%define	__prefix	%{?_prefix}%{!?_prefix:/usr}
%{?!_lib: %define _lib lib}
%{expand: %%define __share %(if [ -d %{__prefix}/share/man ]; then echo /share ; else echo %%{nil} ; fi)}


Summary: The RPM package management system.
Name: rpm
Version: 5.4.15
Release: 0.%(date "+%%Y%%m%%d")
Group: System Environment/Base
URL: http://rpm5.org
Source0: http://rpm5.org/files/rpm/rpm-5.3/rpm-%{version}.tar.gz
Source1: cpu-os-macros.tar.gz
License: LGPLv2
Requires: fileutils
Requires: shadow-utils
## Requires: getconf(GNU_LIBPTHREAD_VERSION) = NPTL

# --- for devtool %checkout
BuildRequires:  cvs
BuildRequires:  git
BuildRequires:  mercurial
BuildRequires:  subversion

# --- used with rpm makefiles
BuildRequires:  cmake
BuildRequires:  bison
BuildRequires:  flex
%if "%{with_apidocs}" == "1"
BuildRequires:  doxygen
BuildRequires:  graphviz
%endif
BuildRequires:  glibc-headers

# --- rpm configure pre-requsites
BuildRequires:  autoconf >= 2.69
BuildRequires:  automake >= 1.14.1
BuildRequires:  libtool >= 2.4.2
BuildRequires:  gettext-devel >= 0.19.2

# --- for make -C tests clean test
BuildRequires:  cpio
BuildRequires:  e2fsprogs
BuildRequires:  file
BuildRequires:  wget
BuildRequires:  db61-utils >= 6.1.19
BuildRequires:  gnupg2 >= 2.0.14
## BuildRequires:       mongodb >= 2.4.9
BuildRequires:  sqlite >= 3.6.20

# --- for rpm mandatory (or nearly so) pre-requisites
BuildRequires:  db61-devel >= 6.1.19
BuildRequires:  popt-devel >= 1.17
BuildRequires:  zlib-devel >= 1.2.3
%if "%{with_bzip2}" == "yes"
BuildRequires:  bzip2-devel >= 1.0
%endif
%if "%{with_xz}" == "yes"
BuildRequires:  xz-devel >= 4.999.8
%endif
BuildRequires:  file-libs >= 5.04
BuildRequires:  file-devel >= 5.04
BuildRequires:  uuid-devel >= 1.6.1
# XXX neon
BuildRequires:  expat-devel >= 2.0.1
BuildRequires:  keyutils-libs-devel >= 1.4

BuildRequires:  elfutils-libelf-devel >= 0.152

# --- for rpm crypto
## BuildRequires:       beecrypt
BuildRequires:  openssl-devel >= 1.0.1e
BuildRequires:  nss-devel >= 3.16.1
BuildRequires:  libgcrypt-devel >= 1.6.0
BuildRequires:  libtomcrypt-devel >= 1.17
BuildRequires:  libtommath-devel >= 0.42.0

# --- for rpm bindings/embeddings
BuildRequires:  libgit2-devel >= 0.21.0
BuildRequires:  libselinux-devel >= 2.0.94
BuildRequires:  libsepol-devel >= 2.0.41
BuildRequires:  libsemanage >= 2.0.43
BuildRequires:  augeas-devel >= 1.0.0
BuildRequires:  sharutils
BuildRequires:  jdk >= 1.8.0_11
## BuildRequires:       lua
BuildRequires:  mruby-devel >= 1.0.0
%if %{with_perl_subpackage}
BuildRequires:  perl-devel >= 2:5.8.0
%endif
%if %{with_python_subpackage}
BuildRequires:  python-devel >= 2.6.6
%endif
BuildRequires:  ruby-devel >= 1.8.7.352
BuildRequires:  squirrel-devel >= 3.0.6
BuildRequires:  tcl-devel >= 8.5.7

BuildRoot: %{_tmppath}/%{name}-root

%description
The RPM Package Manager (RPM) is a powerful command line driven
package management system capable of installing, uninstalling,
verifying, querying, and updating software packages. Each software
package consists of an archive of files along with information about
the package like its version, a description, etc.

%package libs
Summary:  Libraries for manipulating RPM packages.
Group: Development/Libraries
# XXX this Provides: is bogus, but getconf(...) needs to be bootstrapped.
Provides: getconf(GNU_LIBPTHREAD_VERSION) = NPTL
Requires: getconf(GNU_LIBPTHREAD_VERSION) = NPTL

%description libs
This package contains the RPM shared libraries.

%package devel
Summary:  Development files for manipulating RPM packages.
Group: Development/Libraries
Requires: rpm = %{version}-%{release}
Requires: rpm-libs = %{version}-%{release}
Requires: beecrypt >= 4.1.2
Requires: neon-devel
Requires: sqlite-devel
Requires: getconf(GNU_LIBPTHREAD_VERSION) = NPTL

%description devel
This package contains the RPM C library and header files. These
development files will simplify the process of writing programs that
manipulate RPM packages and databases. These files are intended to
simplify the process of creating graphical package managers or any
other tools that need an intimate knowledge of RPM packages in order
to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%package common
Summary: Common RPM paths, scripts, documentation and configuration.
Group: Development/Tools

%description common
The rpm-common package contains paths, scripts, documentation
and configuration common between RPM Package Manager.

%package build
Summary: Scripts and executable programs used to build packages.
Group: Development/Tools
Requires: rpm = %{version}-%{release}, patch >= 2.5
Requires: getconf(GNU_LIBPTHREAD_VERSION) = NPTL

%description build
The rpm-build package contains the scripts and executable programs
that are used to build packages using the RPM Package Manager.

%if %{with_python_subpackage}
%package python
Summary: Python bindings for apps which will manipulate RPM packages.
Group: Development/Libraries
Requires: rpm = %{version}-%{release}
Requires: rpm-libs = %{version}-%{release}
Requires: python >= %{with_python_version}

%description python
The rpm-python package contains a module that permits applications
written in the Python programming language to use the interface
supplied by RPM Package Manager libraries.

This package should be installed if you want to develop Python
programs that will manipulate RPM packages and databases.
%endif

%if %{with_perl_subpackage}
%package perl
Summary: Perl bindings for apps which will manipulate RPM packages.
Group: Development/Libraries
BuildRequires: perl(ExtUtils::MakeMaker) >= 6.17
Requires: rpm = %{version}-%{release}
Requires: rpm-libs = %{version}-%{release}
Obsoletes: perl-RPM, perl-RPM2
Conflicts: perl-RPM, perl-RPM2

%description perl
The rpm-perl package contains a module that permits applications
written in the Perl programming language to use the interface
supplied by RPM Package Manager libraries.

This package should be installed if you want to develop Perl
programs that will manipulate RPM packages and databases.

(Note: rpm-perl is forked from perl-RPM2-0.66, and will obsolete existing perl-RPM packages)
%endif

%prep
# XXX for wdj renamed packaging.
%setup -q -n rpm-%{version}

%build

# XXX rpm needs functioning nptl for configure tests
unset LD_ASSUME_KERNEL || :

%if "%{with_bzip2}" == "yes"
WITH_BZIP2="--with-bzip2"
%else
WITH_BZIP2="--without-bzip2"
%endif

%if "%{with_xz}" == "yes"
WITH_XZ="--with-xz"
%else
WITH_XZ="--without-xz"
%endif
WITH_Z="--with-zlib $WITH_BZIP2 $WITH_XZ"

%if %{with_python_subpackage}
WITH_PYTHON="--with-python=%{with_python_version} --with-pythonembed"
%else
WITH_PYTHON="--without-python --without-pythonembed"
%endif

%if %{with_perl_subpackage}
WITH_PERL="--with-perl --without-perlembed"
%else
WITH_PERL="--without-perl --without-perlembed"
%endif

# XXX FIXME: eliminate --with-sqlite
WITH_DB="--with-db --with-dbsql --without-db-tools-integrated --without-sqlite"

# XXX FIXME: turn on NSS.
WITH_CRYPTO="--with-beecrypt=internal --with-openssl --with-nss --with-gcrypt --with-tomcrypt --without-libtpm"

%ifos linux
WITH_KEYUTILS="--with-keyutils"
WITH_LIBELF="--with-libelf"
WITH_SELINUX="--without-selinux --without-sepol --without-semanage"
WITH_NEON="--with-neon=internal --without-libproxy --with-expat"
%else
WITH_KEYUTILS="--without-keyutils"
WITH_LIBELF="--without-libelf"
WITH_SELINUX="--without-selinux --without-sepol --without-semanage"
# XXX FIXME: neon needs special handling on Mac OS X. external for now.
WITH_NEON="--with-neon --without-libproxy --with-expat"
%endif

%ifarch x86_64
CFLAGS="$CFLAGS -DHAVE_VA_COPY -DVA_COPY=va_copy"; export CFLAGS
%endif
%ifos linux
LDFLAGS="$LDFLAGS -lcrypto"; export LDFLAGS
%endif

#        --enable-build-pie
./configure \
        --verbose \
        --prefix=/usr \
	--infodir='${prefix}%{__share}/info' \
        --libdir='%{_libdir}' \
	--localstatedir=/var \
	--mandir='${prefix}%{__share}/man' \
	--sysconfdir=/etc \
	$WITH_DB \
	$WITH_Z \
        --with-file \
        --with-path-magic=/usr/share/misc/magic \
        --with-lua=internal \
        --with-tcl \
        --with-syck=internal \
        --without-readline \
        --without-augeas \
	$WITH_CRYPTO \
        --without-libtasn1 \
        --without-pakchois \
        --without-gnutls \
	$WITH_NEON \
        --with-pcre \
        --enable-utf8 \
        --with-uuid=system \
        --with-attr \
        --with-acl \
        --without-xar \
        --with-popt=external \
        $WITH_KEYUTILS \
        --with-pthreads \
        $WITH_LIBELF \
        --without-cudf \
        --without-ficl \
        --without-aterm \
        --without-nix \
        --without-bash \
        --without-rc \
        --without-js \
        --without-gpsee \
	$WITH_PYTHON \
	$WITH_PERL \
        --without-ruby \
        --with-mruby \
	--with-java \
	--with-jvm=$JAVA_HOME \
        --with-squirrel \
        --with-build-extlibdep \
        --with-build-maxextlibdep \
        --without-valgrind \
        --disable-openmp \
        --enable-build-pic \
        --enable-build-versionscript \
        --enable-build-warnings \
        --enable-build-debug \
        --enable-maintainer-mode

make -C lua clean || :
make -C python clean || :

make %{?_smp_mflags} \
INSTALLMAN3DIR="%{_mandir}/man3"

%if %{with_apidocs}
make apidocs
%endif

%install
# XXX rpm needs functioning nptl for configure tests
unset LD_ASSUME_KERNEL || :

rm -rf $RPM_BUILD_ROOT

%if %{with_perl_subpackage}
eval `perl '-V:installarchlib'`
mkdir -p $RPM_BUILD_ROOT$installarchlib
%endif

make DESTDIR="$RPM_BUILD_ROOT" install

mkdir -p $RPM_BUILD_ROOT/etc/rpm

mkdir -p $RPM_BUILD_ROOT/var/spool/repackage
mkdir -p $RPM_BUILD_ROOT/var/lib/rpm
for dbi in \
	Basenames Conflictname Dirnames Group Installtid Name Packages \
	Providename Provideversion Requirename Requireversion Triggername \
	Filemd5s Pubkeys Sha1header Sigmd5 \
	__db.001 __db.002 __db.003 __db.004 __db.005
do
    touch $RPM_BUILD_ROOT/var/lib/rpm/$dbi
done

( cd $RPM_BUILD_ROOT/%{_rpmhome}
  tar xzf %{SOURCE1}
  # XXX assume ix86 platforms for the moment
   rm -rf ./alpha-linux
   rm -rf ./alphaev5-linux
   rm -rf ./alphaev56-linux
   rm -rf ./alphaev6-linux
   rm -rf ./alphaev67-linux
   rm -rf ./alphapca56-linux
   rm -rf ./amd64-linux
   rm -rf ./ia32e-linux
   rm -rf ./ia64-linux
   rm -rf ./k6-linux
   rm -rf ./mips-linux
   rm -rf ./mipsel-linux
   rm -rf ./ppc-linux
   rm -rf ./ppc64-linux
   rm -rf ./ppc64iseries-linux
   rm -rf ./ppc64pseries-linux
   rm -rf ./ppciseries-linux
   rm -rf ./ppcpseries-linux
   rm -rf ./s390-linux
   rm -rf ./s390x-linux
   rm -rf ./sparc-linux
   rm -rf ./sparc64-linux
   rm -rf ./sparcv9-linux
)

%find_lang rpm

%if %{with_apidocs}
gzip -9n apidocs/man/man*/* || :
%endif

# Get rid of unpackaged files
cd $RPM_BUILD_ROOT

# rm -f .%{_rpmhome}/{Specfile.pm,cpanflute,cpanflute2,rpmdiff,rpmdiff.cgi,sql.prov,sql.req,tcl.req,trpm}

# rm -f .%{_mandir}/man8/rpmcache.8*
# rm -f .%{_mandir}/man8/rpmgraph.8*
# rm -f .%{_mandir}/ja/man8/rpmcache.8*
# rm -f .%{_mandir}/ja/man8/rpmgraph.8*
# rm -f .%{_mandir}/pl/man8/rpmcache.8*
# rm -f .%{_mandir}/pl/man8/rpmgraph.8*
# rm -rf .%{_mandir}/{fr,ko}

# rm -f .%{_includedir}/popt.h
# rm -f .%{_libdir}/libpopt.*
# rm -f .%{_libdir}/pkgconfig/popt.pc
# rm -f .%{_datadir}/locale/*/LC_MESSAGES/popt.mo
# rm -f .%{_mandir}/man3/popt.3

# rm -f .%{_mandir}/man1/xar.1*
# rm -f .%{_bindir}/xar
# rm -rf .%{_includedir}/xar
# rm -f .%{_libdir}/libxar*

# rm -f .%{_bindir}/lz*
# rm -f .%{_bindir}/unlzma
# rm -f .%{_bindir}/unxz
# rm -f .%{_bindir}/xz*
# rm -rf .%{_includedir}/lzma*
# rm -f .%{_mandir}/man1/lz*.1
# rm -f .%{_libdir}/pkgconfig/liblzma*

  rm -f .%{_rpmhome}/gstreamer.sh
  rm -f .%{_rpmhome}/kmod-deps.sh
  rm -f .%{_rpmhome}/macros.d/gstreamer
  rm -f .%{_rpmhome}/macros.d/kernel

%if %{with_python_subpackage}
# rm -f .%{_libdir}/python%{with_python_version}/site-packages/*.{a,la}
# rm -f .%{_libdir}/python%{with_python_version}/site-packages/rpm/*.{a,la}
%endif

%if %{with_perl_subpackage}
# find .%{_libdir}/perl5 -type f -a \( -name perllocal.pod -o -name .packlist \
#   -o \( -name '*.bs' -a -empty \) \) -exec rm -f {} ';'
# find .%{_libdir}/perl5 -type d -depth -exec rmdir {} 2>/dev/null ';'
%endif

export QA_RPATHS=0x0009

%check
make -C tests clean test sudo=

%clean
rm -rf $RPM_BUILD_ROOT

%pre
/usr/sbin/groupadd -g 37 rpm				> /dev/null 2>&1
/usr/sbin/useradd  -r -d /var/lib/rpm -u 37 -g 37 rpm -s /sbin/nologin	> /dev/null 2>&1
exit 0

%post
/sbin/ldconfig

# Establish correct rpmdb ownership.
/bin/chown rpm:rpm /var/lib/rpm/[A-Z]*

exit 0

%postun
/sbin/ldconfig
if [ $1 = 0 ]; then
    /usr/sbin/userdel rpm
    /usr/sbin/groupdel rpm
fi

%post devel
/sbin/ldconfig

%postun devel
/sbin/ldconfig

%define	rpmattr		%attr(0755, rpm, rpm)
%define	rpmdbattr %attr(0644, rpm, rpm) %verify(not md5 size mtime) %ghost %config(missingok,noreplace)

%files
%pubkey pubkeys/JBJ-GPG-KEY

%rpmattr	%{_bindir}/rpm
%rpmattr	%{_bindir}/rpmconstant

%rpmattr %dir	%{_rpmhome}
%rpmattr	%{_rpmhome}/rpm.*
%rpmattr	%{_rpmhome}/tgpg
%attr(0644, rpm, rpm)	%{_rpmhome}/macros
%attr(0644, rpm, rpm)	%{_rpmhome}/rpmpopt

%rpmattr	%{_rpmhome}/rpmdb_loadcvt
###%rpmattr	%{_rpmhome}/magic
###%rpmattr	%{_rpmhome}/magic.mgc
###%rpmattr	%{_rpmhome}/magic.mime
###%rpmattr	%{_rpmhome}/magic.mime.mgc
%rpmattr	%{_rpmhome}/rpm2cpio
%rpmattr	%{_rpmhome}/vcheck

%rpmattr	%{_rpmhome}/helpers

%rpmattr	%{_rpmhome}/qf

%rpmattr	%{_rpmhome}/cpuinfo.yaml

%rpmattr %dir	%{_rpmhome}/bin
###%rpmattr	%{_rpmhome}/bin/db_*
###%rpmattr	%{_rpmhome}/bin/grep
%rpmattr	%{_rpmhome}/bin/mtree
%rpmattr	%{_rpmhome}/bin/rpmkey
%rpmattr	%{_rpmhome}/bin/rpmrepo
%rpmattr	%{_rpmhome}/bin/rpmspecdump
%rpmattr	%{_rpmhome}/bin/wget

%rpmattr %dir	%{_rpmhome}/lib

%files common -f rpm.lang
%doc CHANGES doc/manual/[a-z]*
%rpmattr	%{_bindir}/rpm2cpio
%rpmattr	%{_bindir}/gendiff
%dir			/etc/rpm
%attr(0755, rpm, rpm)	%dir /var/lib/rpm
%rpmdbattr		/var/lib/rpm/*
%attr(0755, rpm, rpm)	%dir /var/spool/repackage

%attr(0755, rpm, rpm)	%dir %{_usrlibrpm}
%ifarch i386 i486 i586 i686 athlon pentium3 pentium4 x86_64
%attr(-, rpm, rpm)		%{_usrlibrpm}/i[3456]86*
%attr(-, rpm, rpm)		%{_usrlibrpm}/athlon*
%attr(-, rpm, rpm)		%{_usrlibrpm}/pentium*
%attr(-, rpm, rpm)		%{_usrlibrpm}/x86_64*
%endif
%ifarch alpha alphaev5 alphaev56 alphapca56 alphaev6 alphaev67
%attr(-, rpm, rpm)		%{_usrlibrpm}/alpha*
%endif
%ifarch sparc sparcv8 sparcv9 sparc64
%attr(-, rpm, rpm)		%{_usrlibrpm}/sparc*
%endif
%ifarch ia64
%attr(-, rpm, rpm)		%{_usrlibrpm}/ia64*
%endif
%ifarch powerpc ppc ppciseries ppcpseries ppcmac ppc64
%attr(-, rpm, rpm)		%{_usrlibrpm}/ppc*
%endif
%ifarch s390 s390x
%attr(-, rpm, rpm)		%{_usrlibrpm}/s390*
%endif
%ifarch armv3l armv4b armv4l
%attr(-, rpm, rpm)		%{_usrlibrpm}/armv[34][lb]*
%endif
%ifarch armv5teb armv5tel
%attr(-, rpm, rpm)		%{_usrlibrpm}/armv[345]*
%endif
%ifarch mips mipsel
%attr(-, rpm, rpm)		%{_usrlibrpm}/mips*
%endif

%attr(-, rpm, rpm)		%{_usrlibrpm}/noarch*

%dir %{__prefix}/src/rpm
%dir %{__prefix}/src/rpm/BUILD
%dir %{__prefix}/src/rpm/SPECS
%dir %{__prefix}/src/rpm/SOURCES
%dir %{__prefix}/src/rpm/SRPMS
%dir %{__prefix}/src/rpm/RPMS
%{__prefix}/src/rpm/RPMS/*

%{_mandir}/man8/rpm.8*
%{_mandir}/man8/rpm2cpio.8*
%lang(fr)	%{_mandir}/fr/man8/rpm.8*
%lang(ja)	%{_mandir}/ja/man8/rpm.8*
%lang(ja)	%{_mandir}/ja/man8/rpm2cpio.8*
#%lang(ko)	%{_mandir}/ko/man8/rpm.8*
#%lang(ko)	%{_mandir}/ko/man8/rpm2cpio.8*
%lang(pl)	%{_mandir}/pl/man8/rpm.8*
%lang(pl)	%{_mandir}/pl/man8/rpm2cpio.8*
%lang(ru)	%{_mandir}/ru/man8/rpm.8*
%lang(ru)	%{_mandir}/ru/man8/rpm2cpio.8*
%lang(sk)	%{_mandir}/sk/man8/rpm.8*

%{_mandir}/man1/gendiff.1*
%{_mandir}/man1/rpmgrep.1*
%{_mandir}/man8/rpmbuild.8*
%{_mandir}/man8/rpmconstant.8*
###%{_mandir}/man8/rpmcache.8*
%{_mandir}/man8/rpmdeps.8*
%{_mandir}/man8/rpmmtree.8*
#%lang(ja)	%{_mandir}/ja/man1/gendiff.1*
%lang(ja)	%{_mandir}/ja/man8/rpmbuild.8*
#%lang(ja)	%{_mandir}/ja/man8/rpmdeps.8*
#%lang(ko)	%{_mandir}/ko/man1/gendiff.1*
#%lang(ko)	%{_mandir}/ko/man8/rpmbuild.8*
#%lang(ko)	%{_mandir}/ko/man8/rpmdeps.8*
%lang(pl)	%{_mandir}/pl/man1/gendiff.1*
%lang(pl)	%{_mandir}/pl/man8/rpmbuild.8*
%lang(pl)	%{_mandir}/pl/man8/rpmdeps.8*
#%lang(ru)	%{_mandir}/ru/man1/gendiff.1*
#%lang(ru)	%{_mandir}/ru/man8/rpmbuild.8*
#%lang(ru)	%{_mandir}/ru/man8/rpmdeps.8*
#%lang(sk)	%{_mandir}/sk/man1/gendiff.1*
#%lang(sk)	%{_mandir}/sk/man8/rpmbuild.8*
#%lang(sk)	%{_mandir}/sk/man8/rpmdeps.8*

%files libs
%{_libdir}/librpm-5.4.so
%{_libdir}/librpmconstant-5.4.so
%{_libdir}/librpmdb-5.4.so
%{_libdir}/librpmio-5.4.so
%{_libdir}/librpmmisc-5.4.so
%{_libdir}/librpmbuild-5.4.so

###%{_rpmhome}/lib/libxar.so.*
###%{_rpmhome}/lib/libjs.so.*
###%{_rpmhome}/lib/librpmjsm.so.*
###%{_rpmhome}/lib/rpmjsm.so

%files build
%rpmattr	%{_bindir}/rpmbuild

%rpmattr	%{_rpmhome}/brp-*
%rpmattr	%{_rpmhome}/check-files
%rpmattr	%{_rpmhome}/cross-build
%rpmattr	%{_rpmhome}/dbconvert.sh
%rpmattr	%{_rpmhome}/find-debuginfo.sh
%rpmattr	%{_rpmhome}/find-lang.sh
%rpmattr	%{_rpmhome}/find-prov.pl
%rpmattr	%{_rpmhome}/find-provides.perl
%rpmattr	%{_rpmhome}/find-req.pl
%rpmattr	%{_rpmhome}/find-requires.perl
%rpmattr	%{_rpmhome}/getpo.sh
%rpmattr	%{_rpmhome}/http.req
%rpmattr	%{_rpmhome}/javadeps.sh
%rpmattr	%{_rpmhome}/mono-find-provides
%rpmattr	%{_rpmhome}/mono-find-requires

%rpmattr	%{_rpmhome}/executabledeps.sh
%rpmattr	%{_rpmhome}/libtooldeps.sh
%rpmattr	%{_rpmhome}/osgideps.pl
%rpmattr	%{_rpmhome}/perldeps.pl
%rpmattr	%{_rpmhome}/perl.prov
%rpmattr	%{_rpmhome}/perl.req
%rpmattr	%{_rpmhome}/php.prov
%rpmattr	%{_rpmhome}/php.req
%rpmattr	%{_rpmhome}/pkgconfigdeps.sh
%rpmattr	%{_rpmhome}/pythondeps.sh
%rpmattr	%{_rpmhome}/pythoneggs.py*

%rpmattr	%{_rpmhome}/gem_helper.rb
%rpmattr	%{_rpmhome}/rubygems.rb

%rpmattr	%{_rpmhome}/bin/dbconvert
%rpmattr	%{_rpmhome}/bin/debugedit
%rpmattr	%{_rpmhome}/bin/mgo
%rpmattr	%{_rpmhome}/bin/pom2spec
%rpmattr	%{_rpmhome}/bin/rpmcache
%rpmattr	%{_rpmhome}/bin/rpmcmp
%rpmattr	%{_rpmhome}/bin/rpmdeps
%rpmattr	%{_rpmhome}/bin/rpmdigest
##%rpmattr	%{_rpmhome}/bin/abi-compliance-checker.pl
%rpmattr	%{_rpmhome}/bin/api-sanity-autotest.pl
%rpmattr	%{_rpmhome}/bin/api-sanity-checker.pl
%rpmattr	%{_rpmhome}/bin/chroot
%rpmattr	%{_rpmhome}/bin/cp
%rpmattr	%{_rpmhome}/bin/dbsql
%rpmattr	%{_rpmhome}/bin/find
%rpmattr	%{_rpmhome}/bin/install-sh
%rpmattr	%{_rpmhome}/bin/lua
%rpmattr	%{_rpmhome}/bin/luac
%rpmattr	%{_rpmhome}/bin/mkinstalldirs
%rpmattr	%{_rpmhome}/bin/rpmlua
%rpmattr	%{_rpmhome}/bin/rpmluac
%rpmattr	%{_rpmhome}/bin/sqlite3

%rpmattr	%{_rpmhome}/lib/liblua.a
%rpmattr	%{_rpmhome}/lib/liblua.la

%rpmattr %dir	%{_rpmhome}/macros.d
%rpmattr	%{_rpmhome}/macros.d/cmake
%rpmattr	%{_rpmhome}/macros.d/java
%rpmattr	%{_rpmhome}/macros.d/libtool
%rpmattr	%{_rpmhome}/macros.d/mandriva
%rpmattr	%{_rpmhome}/macros.d/mono
%rpmattr	%{_rpmhome}/macros.d/perl
%rpmattr	%{_rpmhome}/macros.d/php
%rpmattr	%{_rpmhome}/macros.d/pkgconfig
%rpmattr	%{_rpmhome}/macros.d/python
%rpmattr	%{_rpmhome}/macros.d/ruby
%rpmattr	%{_rpmhome}/macros.d/selinux
%rpmattr	%{_rpmhome}/macros.d/tcl
%rpmattr	%{_rpmhome}/macros.rpmbuild

#%rpmattr	%{_rpmhome}/symclash.*
%rpmattr	%{_rpmhome}/u_pkg.sh
%rpmattr	%{_rpmhome}/vpkg-provides.sh
%rpmattr	%{_rpmhome}/vpkg-provides2.sh

%if %{with_python_subpackage}
%files python
%{_libdir}/python%{with_python_version}/site-packages/rpm
%endif

%if %{with_perl_subpackage}
%files perl
%{_libdir}/perl5/site_perl/*/*/auto/RPM
%{_libdir}/perl5/site_perl/5.*/*-linux-*/RPM*
%{_mandir}/man3/RPM*
%endif

%files devel
%if %{with_apidocs}
%doc apidocs
%endif
%{_includedir}/rpm
%{_libdir}/librpm.a
%{_libdir}/librpm.la
%{_libdir}/librpm.so
%{_libdir}/librpmconstant.a
%{_libdir}/librpmconstant.la
%{_libdir}/librpmconstant.so
%{_libdir}/librpmdb.a
%{_libdir}/librpmdb.la
%{_libdir}/librpmdb.so
%{_libdir}/librpmio.a
%{_libdir}/librpmio.la
%{_libdir}/librpmio.so
%{_libdir}/librpmmisc.a
%{_libdir}/librpmmisc.la
%{_libdir}/librpmmisc.so
%{_libdir}/librpmbuild.a
%{_libdir}/librpmbuild.la
%{_libdir}/librpmbuild.so
%{_libdir}/pkgconfig/rpm.pc

###%{_rpmhome}/lib/libxar.a
###%{_rpmhome}/lib/libxar.la
###%{_rpmhome}/lib/libxar.so
###%{_rpmhome}/lib/libjs.a
###%{_rpmhome}/lib/libjs.la
###%{_rpmhome}/lib/libjs.so
###%{_rpmhome}/lib/librpmjsm.a
###%{_rpmhome}/lib/librpmjsm.la
###%{_rpmhome}/lib/librpmjsm.so

%changelog
* Thu Jun 02 2011 mdawkins <mattydaw@gmail.com> 5.4.2-0.20110602
- new snapshot date 20110602 for release 5.4.2

* Sat Oct 23 2010 Jeff Johnson <jbj@rpm5.org> - 5.3.5-0.1
- resurrect rpm.spec.

* Tue Jan 22 2008 Jeff Johnson <jbj@rpm5.org> - 5.1-0.1
- resurrect rpm.spec.
