DESCRIPTION = "LoRa Gateway library"
HOMEPAGE = "https://github.com/Lora-net/lora_gateway"
PRIORITY = "optional"
SECTION = "console/utils"
# Semtech license is a modified BSD-style license
LICENSE = "SEMTECH"
LIC_FILES_CHKSUM = "file://LICENSE;md5=a2bdef95625509f821ba00460e3ae0eb"
DEPENDS = ""
PR = "r10"
SRCREV = "v${PV}"

SRC_URI = "git://github.com/Lora-net/lora_gateway.git;protocol=git \
           file://lora-gateway-add-fpga-version-28-31-33.patch \
           file://library_4.0.cfg \
           file://lora-gateway-add-spi-path-function.patch \
           file://ln-lora-spi-dev.sh \
           file://lora-gateway-change-util-tx-continuous-clksrc.patch \
           file://lora-gateway-v28-skip-IQ-invert.patch \
          "

SRC_URI[md5sum] = "9e06a3733a9fea39a3d61f77b412badf"
SRC_URI[sha256sum] = "28fbfe098013908794b32e51d1fed4427f20dd6c8adbbca78df2e1800f5c84dc"

S = "${WORKDIR}/git"

CFLAGS += "-Iinc -I."

do_configure_append() {
    # copy over custom library_4.0.cfg
    cp ${WORKDIR}/library_4.0.cfg ${S}/libloragw/library.cfg
}

do_compile() {
    oe_runmake
}

do_install() {
	install -d ${D}${includedir}/lora
	install -d ${D}${libdir}/lora
	install -m 0644 libloragw/libloragw.a ${D}${libdir}/lora
	install -m 0644 libloragw/library.cfg ${D}${libdir}/lora
	install -m 0644 libloragw/inc/* ${D}${includedir}/lora
	install -m 0644 libloragw/readme.md ${D}${libdir}/lora/lora-gw-readme.md

	install -d ${D}/opt/lora/

	install -d ${D}/opt/lora/gateway-utils
	install -m 0755 libloragw/test_* ${D}/opt/lora/gateway-utils/
	install -m 0755 util_pkt_logger/util_pkt_logger ${D}/opt/lora/gateway-utils/
	install -m 0755 util_spectral_scan/util_spectral_scan ${D}/opt/lora/gateway-utils/
	install -m 0755 util_spi_stress/util_spi_stress ${D}/opt/lora/gateway-utils/
	install -m 0755 util_tx_test/util_tx_test ${D}/opt/lora/gateway-utils/
	install -m 0755 util_tx_continuous/util_tx_continuous ${D}/opt/lora/gateway-utils/
	install -m 0755 util_lbt_test/util_lbt_test ${D}/opt/lora/gateway-utils/
}

do_install_append_mtcdt() {
	install -m 0755 ${WORKDIR}/ln-lora-spi-dev.sh ${D}/opt/lora/
}

PACKAGES += "${PN}-utils ${PN}-utils-dbg"

FILES_${PN} = "${libdir}/lora/lora-gw-readme.md"
FILES_${PN}-utils = "/opt/lora/gateway-utils/* /opt/lora/ln-lora-spi-dev.sh"
FILES_${PN}-utils-dbg = "/opt/lora/gateway-utils/.debug /opt/lora/ln-lora-spi-dev.sh"
FILES_${PN}-dev = "${includedir}/lora ${libdir}/lora/library.cfg"
FILES_${PN}-staticdev = "${libdir}/lora/libloragw.a"

# disable this on purpose for dev purposes
do_rm_work() {
	echo "skipping"
}

