SUMMARY = "Open source MQTT v3.5 implemention"
DESCRIPTION = "Mosquitto is an open source (BSD licensed) message broker that implements the MQ Telemetry Transport protocol version 3.5. MQTT provides a lightweight method of carrying out messaging using a publish/subscribe model. "
HOMEPAGE = "http://mosquitto.org/"
SECTION = "console/network"
LICENSE = "EPL-1.0 EDL-1.0"
LIC_FILES_CHKSUM = "file://LICENSE.txt;md5=62ddc846179e908dc0c8efec4a42ef20"

# util-linux is needed to provide libuuid dependancy
DEPENDS = "c-ares openssl util-linux"

PR = "r2"

SRC_URI = "http://mosquitto.org/files/source/${PN}-${PV}.tar.gz \
           file://mosquitto.init \
           file://mosquitto.conf \
           file://mosquitto.default \
           file://mosquitto.logrotate.conf \
           file://nostrip.patch \
           "

SRC_URI[md5sum] = "cd879f5964311501ba8e2275add71484"
SRC_URI[sha256sum] = "591f3adcb6ed92c01f7ace1c878af728b797fe836892535620aa6106f42dbcc6"

inherit autotools update-rc.d

INITSCRIPT_NAME = "mosquitto"
INITSCRIPT_PARAMS = "defaults 70 30"

do_install() {
    oe_runmake DESTDIR=${D} prefix=/usr install
    install -m 0644 lib/libmosquitto.a ${D}${libdir}/

    install -d ${D}${sysconfdir}/init.d
    install -d ${D}${sysconfdir}/default
    install -m 0755 ${WORKDIR}/mosquitto.init ${D}${sysconfdir}/init.d/mosquitto
    install -m 0644 ${WORKDIR}/mosquitto.conf ${D}${sysconfdir}/mosquitto/
    install -m 0644 ${WORKDIR}/mosquitto.default ${D}${sysconfdir}/default/mosquitto

    install -d ${D}${sysconfdir}/logrotate.d
    install -m 0644 ${WORKDIR}/mosquitto.logrotate.conf ${D}${sysconfdir}/logrotate.d/mosquitto.conf
}

PACKAGES += "libmosquitto1 libmosquittopp1 ${PN}-clients ${PN}-python"

CONFFILES_${PN} = "${sysconfdir}/mosquitto.conf ${sysconfdir}/default/mosquitto"
FILES_${PN} = "${sbindir}/mosquitto \
               ${bindir}/mosquitto_passwd \
               ${sysconfdir} \
"

FILES_libmosquitto1 = "${libdir}/libmosquitto.so.1"

FILES_libmosquittopp1 = "${libdir}/libmosquittopp.so.1"

FILES_${PN}-clients = "${bindir}/mosquitto_pub \
                       ${bindir}/mosquitto_sub \
"

FILES_${PN}-staticdev += "${libdir}/libmosquitto.a"

FILES_${PN}-python = "/usr/lib/python2.7/site-packages"

