FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"

SRC_URI += "file://ssh.default"

KEYFILES = "ssh_host_dsa_key \
ssh_host_dsa_key.pub \
ssh_host_ecdsa_key \
ssh_host_ecdsa_key.pub \
ssh_host_rsa_key \
ssh_host_rsa_key.pub \
ssh_host_ed25519_key \
ssh_host_ed25519_key.pub \
"

do_install_append() {
  install -d ${D}${sysconfdir}/default
  install -m 644 ${WORKDIR}/ssh.default ${D}${sysconfdir}/default/ssh
  for f in ${KEYFILES}; do
    ln -sf /var/config/ssh/$f ${D}${sysconfdir}/ssh/$f
  done
}
