# Conduit 0.0 or 0.1 without RS9113
require mlinux-base-image.bb
DESCRIPTION = "mLinux factory image"

LIGHTTPD = "lighttpd \
            lighttpd-module-cgi lighttpd-module-indexfile \
            lighttpd-module-redirect lighttpd-module-auth  \
            lighttpd-module-access lighttpd-module-accesslog \
            lighttpd-module-rewrite lighttpd-module-proxy lighttpd-module-fastcgi \
            lighttpd-module-scgi lighttpd-module-alias \
            lighttpd-module-dirlisting  lighttpd-module-staticfile \
            "

# Lighttpd web server
IMAGE_INSTALL += "${LIGHTTPD}"

IMAGE_INSTALL += "sqlite3"

IMAGE_INSTALL += "autossh"

# Monit system/process monitor
IMAGE_INSTALL += "monit"

# LoRa support (MTAC-LORA accessory card)
IMAGE_INSTALL += "lora-gateway-utils lora-network-server lora-query lora-packet-forwarder-usb"

# MQTT server
IMAGE_INSTALL += "mosquitto mosquitto-clients"

# Perl support
IMAGE_INSTALL += "perl"
IMAGE_INSTALL += "perl-module-io perl-module-fcntl"
# not in meta-oe or oe-core...
#IMAGE_INSTALL += "libdevice-serialport-perl"
#IMAGE_INSTALL += "libexpect-perl"

# Python support
IMAGE_INSTALL += "python"
# Python modules
IMAGE_INSTALL += "python-async \
python-argparse \
python-compression \
python-dateutil \
python-html \
python-psutil \
python-pycurl \
python-pyopenssl \
python-pyserial \
python-pyudev \
python-pyusb \
python-simplejson \
python-sqlite3 \
python-syslog \
python-textutils \
python-unixadmin \
python-xml \
"

# Ruby support
IMAGE_INSTALL += "ruby"
IMAGE_INSTALL += "ruby-sqlite3"
IMAGE_INSTALL += "ruby-serialport"

# OpenJDK Java runtime
IMAGE_INSTALL += "openjdk-7-jre"
# OpenJDK with JamVM VM (Multi-Tech default)
IMAGE_INSTALL += "openjdk-7-vm-jamvm"
# OpenJDK with CACAO VM (run with 'java -cacao')
IMAGE_INSTALL += "openjdk-7-vm-cacao"
# OpenJDK Zero VM (run with 'java -zero')
IMAGE_INSTALL += "openjdk-7-vm-zero"

# PHP support
IMAGE_INSTALL += "php php-cli php-cgi"

# Node.js support
IMAGE_INSTALL += "nodejs nodejs-npm"

# Multi-Tech SMS Utility (see http://git.multitech.net)
IMAGE_INSTALL += "sms-utils"
# Multi-Tech GPS Utility
IMAGE_INSTALL += "venus-gps"
IMAGE_INSTALL += "pps-tools"

# When ntp is to use the GPS, gps-utils is required
IMAGE_INSTALL += "gpsd ntp ntp-utils gps-utils gpsd-udev"

IMAGE_INSTALL += "uvccapture"
