DESCRIPTION = "mLinux minimal image"
LICENSE = "MIT"

inherit core-image
inherit mlinux-image

IMAGE_LINGUAS = ""
IMAGE_FEATURES += "ssh-server-openssh package-management"

CORE_FEATURES = "packagegroup-core-boot packagegroup-distro-base \
                 packagegroup-base-ext2 \
                 packagegroup-base-usbhost packagegroup-base-usbgadget \
                 udev-extraconf usb-gadget-mode \
                 sysfsutils module-init-tools kernel-modules \
                 bash procps mtd-utils mtd-utils-jffs2 \
                 openssh-sftp-server \
                 util-linux-mount util-linux-umount \
                 start-stop-daemon \
                 ${CORE_IMAGE_EXTRA_INSTALL} \
                 mlinux-feed-configs \
                 "

NETWORKING_FEATURES = "ppp curl iproute2 \
                       iptables iputils \
                       "

# mts-io: IO Controller for Multi-Tech hardware.
#         (LEDs, temp sensor, serial lines, and more)
#
# config: Handles default config files stored in /var/config. 
#         /var/config is mounted on a separate flash partition so that config
#         files survive flashing of rootfs. See recipe for details.
#
# set-rs485: enables RS485 half-duplex mode for a given tty device

MULTITECH_FEATURES = "mts-io config mts-id-eeprom set-rs485"

UPGRADE_FEATURES = "upgrade-reboot mtd-utils-static"

IMAGE_INSTALL = "${CORE_FEATURES} \
                 ${NETWORKING_FEATURES} \
                 ${UPGRADE_FEATURES} \
                 ${MULTITECH_FEATURES} \
                 "

