DESCRIPTION = "mLinux Conduit Access Point image"

require mlinux-minimal-image.bb

FILESYSTEM_FEATURES = "dosfstools \
                       cifs-utils \
                       lsof \
                       "

NETWORKING_FEATURES += "bridge-utils \
                       inetutils-ftp \
                       openssl \
                       rsync \
                       iperf \
                       mii-diag \
                       tcpdump \
                       netcat \
                       wget \
                       strongswan \
                       "

TIME_FEATURES = "tzdata tzdata-africa tzdata-americas tzdata-antarctica tzdata-arctic \
                 tzdata-asia tzdata-atlantic tzdata-australia tzdata-europe tzdata-pacific \
                 tzdata-misc \
                 cronie \
                 ntpdate \
                 "

WIFI_FEATURES = "libnl \
                wpa-supplicant \
                wireless-tools \
                iw \
                hostap-daemon hostap-utils \
                wilc1000 \
                "

MULTITECH_FEATURES += " \
                 u-boot-linux-utils \
                 mlinux-scripts \
                 reset-handler \
                 radio-cmd radio-query \
                 jsparser \
                 protobuf \
                 annex-client \
                 "

IMAGE_INSTALL += "lora-network-server \
                  lora-gateway-utils \
                  lora-query \
                  mosquitto mosquitto-clients \
                 "

MISC_FEATURES = "minicom lrzsz nano"

# Extra stuff to install
#   Someday add wifi features
#               ${WIFI_FEATURES}
#
IMAGE_INSTALL += " \
                ${FILESYSTEM_FEATURES} \
                ${TIME_FEATURES} \
                ${MISC_FEATURES} \
                "

# Multi-Tech SMS Utility (see http://git.multitech.net)
IMAGE_INSTALL += "sms-utils"
