#!/bin/bash

# Copyright (C) 2014 Multi-Tech Systems

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

name="reset-handler"
log="logger -t $name -s"
pid="$$"

short_signal=10 # SIGUSR1
long_signal=12 # SIGUSR2
extralong_signal=1 # SIGHUP

do_reboot() {
	$log "Rebooting on button press"
	sleep 1
	reboot
}

do_restore_defaults() {
	$log "Removing /var/config contents"
	rm -rf /var/config/*
	$log "Setting restore defaults on reboot"
	touch /var/config/force_defaults
	$log "Rebooting"
	sleep 1
	reboot
}

log_exit() {
	$log "Exiting on SIGTERM"
	exit 0
}

idle_wait() {
	pipe=/var/tmp/$name.fifo
	rm -f $pipe
	mkfifo -m 400 $pipe

	# sneaky way to do nothing forever
	while true; do
		read < $pipe
	done
}

trap do_reboot $short_signal
trap do_restore_defaults $long_signal
trap do_restore_defaults $extralong_signal
trap log_exit TERM

$log "Enabling reset-monitor for pid $pid"
mts-io-sysfs store reset-monitor "$pid $short_signal $long_signal $extralong_signal"
# set long press to 5 seconds for reset to defaults
mts-io-sysfs store reset-monitor-intervals "5 30"

# wait for signals
idle_wait
