DESCRIPTION = "Node-RED"
HOMEPAGE = "http://nodered.org"
LICENSE = "Apache-2.0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Apache-2.0;md5=89aea4e17d99a7cacdbeed46a0096b10"
DEPENDS = "nodejs nodejs-native"
PR = "r0"

inherit npm

S = "${WORKDIR}"

do_install() {

    # npm install locally
    oe_runnpm install --prefix ./ node-red@0.11.1

    # npm install more stuff
    oe_runnpm install --prefix ./node_modules/node-red serialport nodemailer

    # modules needed for loragw
    oe_runnpm install --prefix ./node_modules/node-red extend dissolve node-constants

    # install m2x node
    oe_runnpm install --prefix ./node_modules/node-red node-red-m2x

    # remove dupe deps
    oe_runnpm dedupe

    # remove Raspberry PI node
    rm ./node_modules/node-red/nodes/core/hardware/36-rpi-gpio.html
    rm ./node_modules/node-red/nodes/core/hardware/36-rpi-gpio.js
    rm ./node_modules/node-red/nodes/core/hardware/nrgpio
    rm ./node_modules/node-red/nodes/core/hardware/nrgpio.py

    # install node-red
    install -d ${D}/opt/node-red
    cp -r ./node_modules/node-red/* ${D}/opt/node-red/
}

FILES_${PN} += "/opt/node-red"
