#!/bin/bash
# Fix file creation for U-Blox GPS.
# If GPS reaches expected
# fix level, file GSP_FIXFILE is created.
# This is to know when to set the system
# and hardware clock, and when 
# it is safe to start ntp.
if [[ -r /etc/default/gpsd ]] ; then
  . /etc/default/gpsd
else
  echo "Must configure GPSD requirements"
  exit 1
fi
UBXNAVSOL='b56201063400'
UBXNAVSOLLEN=60

function rm_gps_file
{
  if [[ -n "${GPS_FIXFILE}" ]] && [[ -f ${GPS_FIXFILE} ]] ; then
    rm -f "${GPS_FIXFILE}"
  fi
}

# Most exits are errors, so remove the GPS fix file.
trap rm_gps_file EXIT

if ! [[ -x /usr/bin/gpsmon ]] ; then
  logger -p user.err "gpsd_ubx_3dfix.sh:  Please install gpsmon"
  exit 0
fi


# Terminate gpsmon after 10 seconds if it is our child
(
  sleep 10
  ppid=$$
  # echo "looking for shell ${ppid}"
  gpsmonpid=$(ps -o pid,ppid,comm -e | egrep "[[:space:]]${ppid}[[:space:]]+gpsmon$" | sed -r 's/^[[:space:]]*([0-9]*)[[:space:]]+.*/\1/')
  # echo sleeper TERM found pid $gpsmonpid
  if ((${#gpsmonpid})) ; then
    logger -p user.info "terminating gpscat(${gpsmonpid}) with SIGTERM"
    kill ${gpsmonpid}
  else
    exit 0
  fi
  sleep 2
  gpsmonpid=$(ps -o pid,ppid,comm -e | egrep "[[:space:]]${ppid}[[:space:]]+gpsmon$" | sed -r 's/^[[:space:]]*([0-9]*)[[:space:]]+.*/\1/')
  # echo sleeper KILL found pid $gpsmonpid
  if ((${#gpsmonpid})) ; then
    logger -p user.info "terminating gpscat(${gpsmonpid}) with SIGKILL"
    kill -9 ${gpsmonpid}
  fi
) &
  
fix=""
status=""

# egrep in busybox has a horrible buffering issue.
# echo My shell pid is $$
# echo Place data fix, status
stuff="$(gpsmon -a 2>&1 | {
  OIFS=${IFS}
  IFS=$'\n'
  while read ln ; do
    if [[ $ln =~ ^[[:space:]]*\(${UBXNAVSOLLEN}\)[[:space:]]*${UBXNAVSOL}....................(..)(.) ]] ; then
      IFS=${OIFS} 
      fix="${BASH_REMATCH[1]}"
      if ((${#fix} == 0)) ; then
	fix="unknown"
      fi
      status=$(echo "${BASH_REMATCH[2]}")
      if ((${#status} == 0)) ; then
	status="unknown"
      fi
      break;
    fi
    oldln="${ln}"
  done
  if ((${#fix})) && ((${#status})) ; then
    echo "$fix,$status"
  else
    echo "${oldln}"
  fi
})"

if ((${#stuff} == 0)) ; then
  logger -p user.err No data from GPS
  exit 1
fi

if [[ -t 1 ]] ; then
  stty echo icanon
fi

OIFS=${IFS}
IFS=,
set $stuff
fix="$1"
status="$2"
IFS=${OIFS}

# fixOK is the least significant bit of a hex single digit
case $status in
  [13579bBdDfF])
    ((fixOK=1))
    ;;
  [02468aAcCeE])
    ((fixOK=0))
    ;;
  *)
    logger -p user.err "Is GPSD running?"
    logger -p user.err "FIX OK field should be single hex digit: gpsmon data: $stuff"
    exit 1
    break
    ;;
esac

# echo "status is $status.  fixOK is $fixOK"


if ((fixOK == 0)) ; then
  logger -p user.err "Problem with the GPS fix.  The fix is an even value, \"$status\", and should be an odd value.  fixOK=${fixOK}"
  exit 1
  # Retry later.  How?
fi

# echo "fix is $fix.   Is it in $GPSFIX?"
# Test the GPS fixOK
for x in $GPSFIX ; do
  # echo test $x with $fix
  if [[ $x == $fix ]] ; then
    logger user.info "GPS has fix $fix found in list GPSFIX: $GPSFIX"
    echo $x >"${GPS_FIXFILE}"
    GPS_FIXFILE=""
    exit 0
  fi
done

logger -p user.info "GPS fix is bad: $fix and should be one of: $GPSFIX"
# Start later
exit 1

