DESCRIPTION = "A Ruby library that provides a class for using RS-232 serial ports"
HOMEPAGE = "https://github.com/hparra/ruby-serialport"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://LICENSE;md5=751419260aa954499f7abaabaa882bbe"
SECTION = "console/utils"
PRIORITY = "optional"

DEPENDS = "ruby"

PR = "r2"

# tag v1.1.0
SRCREV = "709e385f6d20aaadc7f3252af59250336d27e607"

SRC_URI = "git://github.com/hparra/ruby-serialport.git;protocol=git"

S = "${WORKDIR}/git"

do_compile() {
  ${CC} ${CFLAGS} ${LDFLAGS} -Iext/native -I${STAGING_INCDIR}/ruby-1.9.1 -I${STAGING_INCDIR}/ruby-1.9.1/arm-linux-eabi -c ext/native/*.c
  ${CC} ${CFLAGS} ${LDFLAGS} --shared -o ext/native/serialport.so serialport.o posix_serialport_impl.o
}

do_install() {
  install -d ${D}${libdir}/ruby/serialport
  install lib/serialport.rb ${D}${libdir}/ruby/serialport.rb
  install ext/native/serialport.so -t ${D}${libdir}/ruby
}

FILES_${PN} = "${libdir}/ruby/serialport*"
FILES_${PN}-dbg += "${libdir}/ruby/.debug"
