DESCRIPTION = "Ruby bindings for the SQLite3 embedded database"
HOMEPAGE = "https://github.com/luislavena/sqlite3-ruby"
LICENSE = "custom-freely-distributable"
LIC_FILES_CHKSUM = "file://LICENSE;md5=f24ce0d57c8f8576a36e2803d35bcfec"
SECTION = "console/utils"
PRIORITY = "optional"

DEPENDS = "ruby sqlite3"

PR = "r0"

SRC_URI = "git://github.com/luislavena/sqlite3-ruby.git;tag=v${PV};protocol=git"

S = "${WORKDIR}/git"

do_compile() {
  ${CC} ${CFLAGS} ${LDFLAGS} -Iext/sqlite3 -Iext/native -I${STAGING_INCDIR}/ruby-1.9.1 -I${STAGING_INCDIR}/ruby-1.9.1/arm-linux-eabi -c ext/sqlite3/*.c
  ${CC} ${CFLAGS} ${LDFLAGS} --shared -o ext/sqlite3/sqlite3_native.so *.o -lsqlite3
}

do_install() {
  install -d ${D}${libdir}/ruby ${D}${libdir}/ruby/sqlite3
  install lib/sqlite3.rb ${D}${libdir}/ruby/sqlite3.rb
  install lib/sqlite3/* ext/sqlite3/sqlite3_native.so -t ${D}${libdir}/ruby/sqlite3
}

FILES_${PN} = "${libdir}/ruby/sqlite3*"
FILES_${PN}-dbg += "${libdir}/ruby/sqlite3/.debug*"
