DESCRIPTION = "mts-io controller and sysfs wrapper"
HOMEPAGE = "http://www.multitech.net/"
SECTION = "base"
PRIORITY = "optional"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://io-module/COPYING;md5=94d55d512a9ba36caa9b7df079bae19f \
                    file://io-tool/COPYING;md5=94d55d512a9ba36caa9b7df079bae19f \
"
DEPENDS = "virtual/kernel"
INC_PR = "r9"

SRCREV = "${PV}"

SRC_URI = " \
    git://git.multitech.net/mts-io.git;protocol=git \
    file://led-status_heartbeat_trigger \
    file://lora-led-updater \
    file://mts-io.init \
    file://mts-io.mtcap.init \
    file://radio-reset.init \
    file://radio-reset.default \
    file://mts-io.conf \
"
S = "${WORKDIR}/git"

inherit module-base
inherit update-rc.d

# add this since we aren't using module.bbclass
addtask make_scripts after do_patch before do_compile
do_make_scripts[lockfiles] = "${TMPDIR}/kernel-scripts.lock"
do_make_scripts[deptask] = "do_populate_sysroot"

EXTRA_OEMAKE = " -C ${STAGING_KERNEL_DIR} \
                KBUILD_VERBOSE=1 \
                M=${S}/io-module \
                modules \
                "

do_compile () {
    unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
    oe_runmake
}

PACKAGES = "${PN}"

FILES_${PN} = "${base_libdir}/modules/${KERNEL_VERSION}/extra/mts_io.ko"
FILES_${PN} += "${sysconfdir}"
FILES_${PN} += "${libdir}/mts-io-sysfs*"
FILES_${PN} += "${sbindir}/mts-io-sysfs"
FILES_${PN}_append_mtcap += "${sbindir}/lora-led-updater"

INITSCRIPT_NAME = "mts-io"
INITSCRIPT_PARAMS = "start 39 S ."

PARALLEL_MAKE = ""

fakeroot do_install () {
    install -m 0755 -d ${D}${base_libdir}/modules/${KERNEL_VERSION}/extra
    # use cp instead of install so the driver doesn't get stripped
    cp io-module/mts_io.ko ${D}${base_libdir}/modules/${KERNEL_VERSION}/extra
    cp io-module/mts_io.h ${STAGING_KERNEL_DIR}/include/linux/
    cp io-module/mts_io.h ${STAGING_INCDIR}/linux/
    if [ -f io-module/mts_eeprom.h ]; then
        cp io-module/mts_eeprom.h ${STAGING_KERNEL_DIR}/include/linux/
        cp io-module/mts_eeprom.h ${STAGING_INCDIR}/linux/
    fi

    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/mts-io.init ${D}${sysconfdir}/init.d/mts-io
    install -m 0755 ${WORKDIR}/radio-reset.init ${D}${sysconfdir}/init.d/radio-reset
    install -m 0755 ${WORKDIR}/led-status_heartbeat_trigger ${D}/${sysconfdir}/init.d/
    install -d ${D}${sysconfdir}/default
    install -m 0755 ${WORKDIR}/mts-io.conf ${D}${sysconfdir}/default/mts-io

    # run radio-reset on reboot
    install -d ${D}${sysconfdir}/rc6.d
    ln -sf ${sysconfdir}/init.d/radio-reset ${D}/${sysconfdir}/rc6.d/S30radio-reset

    # blink status LED after booted
    install -d ${D}${sysconfdir}/rc5.d
    ln -sf ${sysconfdir}/init.d/led-status_heartbeat_trigger ${D}/${sysconfdir}/rc5.d/S95led-status_heartbeat_trigger

    install -m 0755 -d ${D}${sbindir}
    install -d ${D}${libdir}/mts-io-sysfs
    install -m 0755 io-tool/mts-io-sysfs-inc.sh ${D}${libdir}/mts-io-sysfs
    install -m 0755 io-tool/mts-io-sysfs ${D}${sbindir}/mts-io-sysfs

    install -d ${D}${sysconfdir}/default
    install -m 0644 ${WORKDIR}/radio-reset.default ${D}${sysconfdir}/default/radio-reset
}

fakeroot do_install_append_mtcap() {
    # install MTCAP mts-io init script
    install -m 0755 ${WORKDIR}/mts-io.mtcap.init ${D}${sysconfdir}/init.d/mts-io
    install -m 0755 ${WORKDIR}/lora-led-updater ${D}${sbindir}/lora-led-updater

    # disable radio-reset for the mtcap hardware
    sed -i 's/ENABLED="yes"/ENABLED="no"/g' ${D}${sysconfdir}/default/radio-reset
}
