PR = "r7"
require u-boot.inc

LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=1707d6db1d42237583f50183a5651ecb"

DEFAULT_PREFERENCE = "-1"

# U-Boot 2012.10 for AT91
# tag: linux4sam_4.0
SRCREV="8978bdafbad84c0c9878c9ff331930ca6edf9a76"

SRC_URI = "git://github.com/linux4sam/u-boot-at91.git;branch=u-boot-2012.10-at91 \
           file://u-boot-2012.10-sam9x5-eth-mii-fix.patch \
           file://u-boot-env-crc-dbg.patch \
           "

# add patch to speed up boot if ethernet autonegotiation fails
SRC_URI += "file://u-boot-2010.06-macb-autoneg-timeout.patch"
# add password protection patch
SRC_URI += "file://u-boot-2012.10-pwd.patch"

SRC_URI_append_mtcdt = " file://u-boot-2012.10-mtcdt.patch"
SRC_URI_append_mtcap = " file://u-boot-2012.10-mtcdt.patch"

TARGET_LDFLAGS = ""

S = "${WORKDIR}/git"

inherit base

do_configure_prepend() {
    mv -f tools/setlocalversion tools/setlocalversion.old
    echo -e "#!/bin/sh\necho '-${MACHINE}-${PR}'" > tools/setlocalversion
    chmod a+rx tools/setlocalversion
}

do_compile () {
       oe_runmake ${UBOOT_MACHINE}
       oe_runmake all
}

