DESCRIPTION = "USB Driver for Redpine RS9113"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"
PACKAGE_ARCH = "mtcdt"
PROVIDES = "rs9113-from-src"
PR = "${MLINUX_KERNEL_VERSION}${MLINUX_KERNEL_EXTRA_VERSION}"

inherit module

SRCREV = "${AUTOREV}"

SRC_URI = " \
        git://git@${MTS_INTERNAL_GIT}/mlinux/meta-rs9113.git;protocol=ssh;branch=${PV};destsuffix=meta/ \
        git://git@${MTS_INTERNAL_GIT}/mlinux/Redpine.git;protocol=ssh;branch=${PV} \
"
SRCXX_URI = " \
    git://git@${MTS_INTERNAL_GIT}/mlinux/Redpine.git;protocol=ssh;branch=${PV};name=machine \
    git://git@${MTS_INTERNAL_GIT}/mlinux/meta-rs9113.git;protocol=ssh;branch=${PV};name=meta \
"

S = "${WORKDIR}/git/source/host"
M = "${WORKDIR}/meta"

EXTRA_OEMAKE = " KERNELDIR=${STAGING_KERNEL_DIR} \
                 CROSS_COMPILE=${TARGET_PREFIX} \
                 ARCH=arm \
                 WLAN_COMPILE_FLAGS='' \
		 V=1 \
                "
                
FILES_${PN} = "/opt/rs9113 ${sbindir}"
FILES_${PN}-dbg = "/opt/rs9113/.debug/"

PARALLEL_MAKE = ""

do_configure() {
   cp ${M}/mtcdt/defconfig .config
}

do_compile () {
   unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
   oe_runmake
}

do_patch () {
	cd ${WORKDIR}/git
	echo "patches" ${M}/patches/*
	for f in ${M}/patches/* ; do
		echo "Patching with ${f}"
		patch -p1 < ${f}
	done
}

do_install() {
   install -m 0755 -d ${D}/opt/rs9113
   cp -r ${S}/release/* ${D}/opt/rs9113/
   rm -rf ${D}/opt/rs9113/flash ${D}/opt/rs9113/certs ${D}/opt/rs9113/*zigb*
   install -m 0755 -d ${D}${sbindir}
   install -m 0755 ${M}/rs9113_load_modules.sh ${D}${sbindir}/
   install -m 0755 ${M}/rs9113_remove_modules.sh ${D}${sbindir}/
}

