require rs9113.inc
DESCRIPTION = "USB Driver for Redpine RS9113"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"
PACKAGE_ARCH = "mtcdt"
PROVIDES = "rs9113"
FILES_${PN} = "/opt/rs9113 ${sbindir} ${sysconfdir}"

# This bitbake recipe requires SSH_AUTH_SOCK to be set if ssh key pass
# phrases are used.  SSH_AUTH_SOCK is set by a keyserver,
# such as gnome-keyring-daemon or ssh-keyagent.

# NOTE: rs9113 binary is built with Jenkin's job using rs9113-from-src_${PV}.bb
# To update this, manually copy ipk from Jenkin's job to
#     git://git@${MTS_INTERNAL_GIT}/mlinux/ipk.git;protocol=ssh;branch=${PV}
#
PR = "r0"
SRC_URI = " \
    file://rs9113/rs9113.init \
    file://rs9113/rs9113.default \
    file://rs9113/wpa_supplicant \
    file://rs9113-ipk/rs9113-from-src_${PV}-${PR}.0_mtcdt.ipk \
"
SRCREV = "${AUTOREV}"
SRC_URI[md5sum] = "ff2238e0fb52b1627e76ca366fc83919"
SRC_URI[sha256sum] = "e303c5bc2e89e0c36303642d2677eadb2f4a9e2e0bb9a8622883abd97fe6e742"
