require rs9113.inc
DESCRIPTION = "USB Driver for Redpine RS9113"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"
PACKAGE_ARCH = "mtcdt"
PROVIDES = "rs9113"
FILES_${PN} = "/opt/rs9113 ${sbindir} ${sysconfdir}"

# This bitbake recipe requires SSH_AUTH_SOCK to be set if ssh key pass
# phrases are used.  SSH_AUTH_SOCK is set by a keyserver,
# such as gnome-keyring-daemon or ssh-keyagent.

# NOTE: rs9113 binary is built with Jenkin's job using rs9113-from-src_${PV}.bb
# To update this, manually copy ipk from Jenkin's job to
#     git://git@${MTS_INTERNAL_GIT}/mlinux/ipk.git;protocol=ssh;branch=${PV}
#
PR = "r0.${MLINUX_KERNEL_VERSION}${MLINUX_KERNEL_EXTRA_VERSION}"
SRC_URI = " \
    file://rs9113/rs9113.init \
    file://rs9113/rs9113.default \
    file://rs9113/wpa_supplicant \
    file://rs9113-ipk/rs9113-from-src_${PV}-${MLINUX_KERNEL_VERSION}${MLINUX_KERNEL_EXTRA_VERSION}.0_mtcdt.ipk \
"
SRCREV = "${AUTOREV}"
# For some reason the md5sum and sha256sum are ignored
SRC_URI[md5sum] = "def9fd10a77cae9df9bcb2e20626795e"
SRC_URI[sha256sum] = "367e942618143d4967273ce44120098a98e2ad1f543a9a404af7082b40c5066e"
