LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/GPL-2.0;md5=801f80980d171dd6425610833a22dbe6"

inherit module

PV = "3.18"
KBRANCH = "kernel-3.18"
SRCREV = "${AUTOREV}"
SRC_URI = "git://github.com/linux4sc/staging.git;protocol=git;branch=${KBRANCH} \
	   file://wilcp1000_3.18_to_3.12_kernel.patch \
	   file://wilc1000.conf \
           https://github.com/linux4sc/wireless-firmware/raw/master/wilc1003_firmware.bin;name=blob \
	  "

SRC_URI[blob.md5sum] = "a3651b5696ac674a3b2100d109bb2757"
SRC_URI[blob.sha256sum] = "57584b0cf000f43405b0ef1201c6d1302cc7f7e187144c7946ce2fa12fb6f49b"

S = "${WORKDIR}/git"

EXTRA_OEMAKE = '-C ${STAGING_KERNEL_DIR} M=${S} \
  CONFIG_ATMEL_SMARTCONNECT=y \
  CONFIG_WILC1000=m \
  CONFIG_WILC1000_SDIO=m \
  '

do_install() {
  echo PN is ${PN}
  install -d ${D}${base_libdir}/modules/${KERNEL_VERSION}/kernel/drivers/net/wireless/atmel/wilc1000
  install -m 0644 ${S}/*${KERNEL_OBJECT_SUFFIX} ${D}${base_libdir}/modules/${KERNEL_VERSION}/kernel/drivers/net/wireless/atmel/wilc1000
  install -d ${D}${sysconfdir}/modprobe.d
  install -m 0644 ${WORKDIR}/wilc1000.conf ${D}${sysconfdir}/modprobe.d
  install -d -m 0755 ${D}/lib/firmware/atmel
  install -m 0644 ${WORKDIR}/wilc1003_firmware.bin ${D}/lib/firmware/atmel
}
FILES_kernel-module-${PN} += "${sysconfdir}/modprobe.d/wilc1000.conf /lib/firmware/atmel/wilc1003_firmware.bin"
